/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_LoadedArtifacts extends BattleAbility config (BattleRPG);

function ServerModifyPlayer (UTPawn P, int Level)
{
  local BattleArtifact BAF;
  local BattleGenInvItem4Pawns BGI; 

  BGI = BattleGenInvItem4Pawns (P.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
  if (BGI != None) {
    if (Level>=1) {
      BAF = New (P) class'BattleRPG.BattleArtifactDraining_Flight';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
      BAF = New (P) class'BattleRPG.BattleArtifactDraining_DoubleDamage';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
    } 
    if (Level>=2) {
      BAF = New (P) class'BattleRPG.BattleArtifactInstant_MagicWeaponMaker';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
      BAF = New (P) class'BattleRPG.BattleArtifactDraining_GodMode';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
      BAF = New (P) class'BattleRPG.BattleArtifactInstant_MaxMagic';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
    }
    if (Level>=3) {
      BAF = New (P) class'BattleRPG.BattleArtifactInstant_MaxMagicPlus2';
      BAF.WorldInfo = P.WorldInfo;
      BGI.AddActiveArtifact (BAF);
    }
  }
}

defaultproperties
{
  AbilityName = "Loaded Artifacts";
  AbilityDescription = "Level 1 gives you Flight and Double Damage when you spawn. With level 2 you also get the Magic Weapon Maker, Max Magic and God Mode. With level 3 you also get Max Magic +2.";
  AbilityMaxLevel = 3;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}