/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeapon_FlakCannon extends UTWeap_FlakCannon;

var BattleWeaponMagic ActiveBWM;
var int ActiveBWMLevel;
var Material MagicMaterial;
var string MyName; // Determine the name on the server, show it on the client

replication
{
  if (Role == ROLE_Authority)
    MyName, MagicMaterial;
}

// Initialize the weapon
simulated function PostBeginPlay() 
{
  local BattleRPG BRPG;
  Super.PostBeginPlay();
  BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (WorldInfo);  
  if (BRPG != None) BRPG.CreateWeaponMagic (Self, ActiveBWM, ActiveBWMLevel);
  Rename ();
}

function Rename ()
{
  if (ActiveBWM != None) {
    MyName = ActiveBWM.WeaponName (Super.GetHumanReadableName(), ActiveBWMLevel);
  } else {
    MyName = Super.GetHumanReadableName();
  }
}

simulated function String GetHumanReadableName()
{
  return MyName;
}

simulated function Tick(float DeltaTime)
{
  if (MagicMaterial != None) {
    SetSkin (MagicMaterial);
  }
}

simulated function Projectile ProjectileFire()
{
  local Projectile PR;

  PR = Super.ProjectileFire();

  if (ActiveBWM != None && PR != None) {
    ActiveBWM.ModifyProjectile (PR, ActiveBWMLevel);
  }

  return PR;
}

simulated function CustomFire()
{
	local int i,j;
   	local vector RealStartLoc, AimDir, YDir, ZDir;
	local Projectile Proj;
	local class<Projectile> ShardProjectileClass;
	local float Mag;

	IncrementFlashCount();

	if (Role == ROLE_Authority)
	{
		// this is the location where the projectile is spawned
		RealStartLoc = GetPhysicalFireStartLoc();
		// get fire aim direction
		GetAxes(GetAdjustedAim(RealStartLoc),AimDir, YDir, ZDir);

		// special center shard
		Proj = Spawn(CenterShardClass,,, RealStartLoc);

        if (ActiveBWM != None && Proj != None) {
          ActiveBWM.ModifyProjectile (Proj, ActiveBWMLevel);
        } 

		if (Proj != None)
		{
			Proj.Init(AimDir);
		}

		// one shard in each of 9 zones (except center)
		ShardProjectileClass = GetProjectileClass();
		for ( i=-1; i<2; i++)
		{
			for ( j=-1; j<2; j++ )
			{
				if ( (i != 0) || (j != 0) )
				{
					Mag = (abs(i)+abs(j) > 1) ? 0.7 : 1.0;
					Proj = Spawn(ShardProjectileClass,,, RealStartLoc);

                    if (ActiveBWM != None && Proj != None) {
                      ActiveBWM.ModifyProjectile (Proj, ActiveBWMLevel);
                    } 

					if (Proj != None)
					{
						Proj.Init(AimDir + (0.3 + 0.7*FRand())*Mag*i*SpreadDist*YDir + (0.3 + 0.7*FRand())*Mag*j*SpreadDist*ZDir );
					}
				}
			}
	    }
	}
}

defaultproperties
{
}