/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Vampirism extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true;
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local int Bonus;
  local int AbilityMaxGainedHealth;

  if (Damage < 0) return; // E.g. healing a vehicle with a link gun
  if (P == InjuredPawn) return;

  Bonus = int (Damage * 0.05 * Level);  

  // Check if InjuredPawn has enough Health left, otherwise reduce the bonus.
  if (InjuredPawn!=None) {
    if (Damage > InjuredPawn.Health) Bonus = int (InjuredPawn.Health * 0.05 * Level);
  }

  // Do this in such a way the 300 health bonus (Mana) doesn't get lost.
  AbilityMaxGainedHealth = P.HealthMax + 100;
  if (P.Health < AbilityMaxGainedHealth) {
    P.Health += Bonus;
    if (P.Health > AbilityMaxGainedHealth) P.Health = AbilityMaxGainedHealth;
  }  

  Damage = Damage * (1.0 + Level * 0.03); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Vampirism";
  MagicMaxLevel = 10;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Blood';
  bPositiveMagic = true;
  DamageChangePercentage = 3;
}