/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.

    This file also contains code that is derived from code which is
    Copyright 1998-2007 Epic Games, Inc. All Rights Reserved. That part 
    of the code is covered by the Epic license and not by the GPL.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

class BattleScoreboardClockRPG extends UTScoreboardClockPanel;

// Derived from UTScoreboarPanel.uc
event DrawPanel()
{
  local WorldInfo WI;
  local UTGameReplicationInfo GRI;
  local string Clock;
  local float TextWidth, TextHeight;
  local float PadWidth, PadHeight;

  WI = UTHudSceneOwner.GetWorldInfo();
  GRI = UTGameReplicationInfo(WI.GRI);
  if (GRI != None && !GRI.bMatchISOver) {
    if (ClockFont != none) {
      Clock = "BattleRPG"@`BRPG_Version@class'UTHUD'.static.FormatTime (GRI.TimeLimit != 0 ? GRI.RemainingTime : GRI.ElapsedTime);
      Canvas.Font = ClockFont;
      Canvas.StrLen (Clock, TextWidth, TextHeight);
      Canvas.StrLen ("000000", PadWidth, PadHeight);
      if (Background != None) {
        Canvas.ClipY = TextHeight + TextHeight*0.25f;
        Canvas.SetPos (Canvas.ClipX - (TextWidth + PadWidth), 0);
        Canvas.DrawColorizedTile (Background, TextWidth + PadWidth, Canvas.ClipY, BackCoords.U,BackCoords.V,BackCoords.UL,BackCoords.VL, BackColor);
      }
      Canvas.SetDrawColor(255,255,255,255);
      Canvas.SetPos (Canvas.ClipX - (TextWidth + PadWidth*0.5f), TextHeight*0.1);
      Canvas.DrawText (Clock);
    }
  }
}

defaultproperties
{
}