/* 
    BattleRPG Copyright (C) 2007-2009 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

class BattleMainMenu extends UTUIScene;

var transient UILabelButton Button_Next;
var transient UILabelButton Button_Buy;
var transient UILabelButton Button_Sell;
var transient UILabelButton Button_Close;
var transient UTUIComboBox  Combo_Ability;

var transient UTUIDataStore_StringList StringStore;

var BattlePlayerController BPC;

event PostInitialize()
{
  super.PostInitialize();

//  SetTimer (1.0, True, 'ClientTimer'); 

  Button_Next = UILabelButton(FindChild('Button_Next', true));
  Button_Next.OnClicked = OnClicked;

  Button_Buy = UILabelButton(FindChild('Button_Buy', true));
  Button_Buy.OnClicked = OnClicked;

  Button_Sell = UILabelButton(FindChild('Button_Sell', true));
  Button_Sell.OnClicked = OnClicked;

  Button_Close = UILabelButton(FindChild('Button_Close', true));
  Button_Close.OnClicked = OnClicked;

  Combo_Ability = UTUIComboBox(FindChild('ComboAbility', true));
  Combo_Ability.ComboEditbox.SetReadOnly(true);
}

function InitCombo ()
{
  local int i;
  local int v;
  local string s;

  v = Combo_Ability.ComboList.Index;
  StringStore = UTUIDataStore_StringList (ResolveDataStore ('UTStringList'));
  StringStore.Empty('Abilities');
  for (i=0; i<BPC.ReplicatedDynamicAbilitiesLength; i++) {
    if (BPC.PlayerNextAbilityCost(i) == 0) {
      s = BPC.AvailableAbilities[i].AbilityName@"(n/a)";
      StringStore.AddStr('Abilities', s);
    } else if (BPC.PlayerNextAbilityCost(i) == -1) {
      s = BPC.AvailableAbilities[i].AbilityName@"(max)";
      StringStore.AddStr('Abilities', s);
    } else {
      s = BPC.AvailableAbilities[i].AbilityName@"("$BPC.PlayerNextAbilityCost(i)$"$)";
      StringStore.AddStr('Abilities', s);
    }
  }  
  Combo_Ability.ComboList.SetDataStoreBinding("<UTStringList:Abilities>");
  Combo_Ability.ComboList.RefreshSubscriberValue();
  if (BPC.ReplicatedDynamicAbilitiesLength < 25) {
    Combo_Ability.ComboList.SetRowCount(BPC.ReplicatedDynamicAbilitiesLength);
  } else {
    Combo_Ability.ComboList.SetRowCount(25);
  }
  if (v>0) {
    Combo_Ability.SetSelectedItem (v);
  }
}

function bool OnRawInputKey (const out InputEventParameters EventParms)
{
  if (IsSceneActive() && (EventParms.InputKeyName=='Escape' || EventParms.InputKeyName=='L') && EventParms.EventType == IE_Pressed) { // DW>Chococake: Also added IsSceneActive() check
    BPC.BMM = None;  // DW>Chococake: added
    CloseScene(self);
  }
  return false;
}

function bool OnClicked(UIScreenObject EventObject, int PlayerIndex)
{
  if(EventObject==Button_Close) {
    BPC.BMM = None;  // DW>Chococake: added
    CloseScene(self);
  } else {
    if (BPC != None) {
      if (EventObject==Button_Next) {
        if (Combo_Ability.ComboList.Index == BPC.ReplicatedDynamicAbilitiesLength - 1) {
          Combo_Ability.SetSelectedItem (0);
        } else {
          Combo_Ability.SetSelectedItem (Combo_Ability.ComboList.Index + 1);
        }
      } else if (EventObject==Button_Buy) {
        BPC.BuyAbility (BPC.UICurrentAbility);
      } else if (EventObject==Button_Sell) {
        BPC.SellAbility (BPC.UICurrentAbility);
      }
    }
  }
  return true;
}

defaultproperties
{
  bPauseGameWhileActive=False
  __OnRawInputKey__Delegate=Default__BattleMainMenu.OnRawInputKey
  Name="Default__BattleMainMenu"
}