/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_WeaponResurrection extends BattleAbility config (BattleRPG);

function ServerModifyPlayer (UTPawn P, int Level)
{
  local BattlePlayerController BPC;
  local UTWeapon W;
  local BWEAPDATA BW;

  BPC = BattlePlayerController (P.Owner);
  if (BPC != None && BPC.LastActiveWeapon != None) {
    W = UTWeapon(P.FindInventoryType(BPC.LastActiveWeapon));
    if (W != None) W.Destroy(); // Due to not knowing another way to select it
    W = UTWeapon(P.CreateInventory(BPC.LastActiveWeapon, false));
    if (W != None && BPC.LastActiveWeaponMagicLevel > 0) {
      if (BPC.LastActiveWeaponMagic == class'BattleWeaponMagic_UltraGIB' || BPC.LastActiveWeaponMagic == class'BattleWeaponMagic_Quantum') {
        BW.ActiveBWM = New (W) class'BattleWeaponMagic_IncreasedDamage';
      } else {
        BW.ActiveBWM = New (W) BPC.LastActiveWeaponMagic;
      }
      BW.ActiveBWMLevel = BPC.LastActiveWeaponMagicLevel;
      BW.MagicMaterial = BW.ActiveBWM.MagicMaterial;
      class'BattleStaticFunctions'.static.WriteWEAP (W, BW);
    }
  }
}

defaultproperties
{
  AbilityName = "Weapon Resurrection";
  AbilityDescription = "If you respawn you get the weapon (including magic) you used when you died. Ultra GIB magic will not be resurrected.";
  AbilityMaxLevel = 1;
  AbilityLevel1Cost = 50;
  AbilityCostIncreasePerLevel = 0;
}