/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_LoadedMedic extends BattleAbility config (BattleRPG);

function ServerModifyPlayer (UTPawn P, int Level)
{
  local BattleArtifact BAF;
  local BattleGenInvItem4Pawns BGI; 

  BGI = BattleGenInvItem4Pawns (P.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
  if (BGI != None) {
    BAF = New (P) class'BattleRPG.BattleArtifactInstant_MedicWeaponMaker';
    BAF.WorldInfo = P.WorldInfo;
    BGI.AddActiveArtifact (BAF);
  }
}

defaultproperties
{
  AbilityName = "Loaded Medic";
  AbilityDescription = "Gives you a medic weapon maker.";
  AbilityMaxLevel = 1;
  AbilityLevel1Cost = 25;
}