/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_LoadedMagic extends BattleAbility config (BattleRPG);

function ServerTimer (UTPawn P, int Level)
{
  local BWEAPDATA BW;
  local BattleRPG BRPG;
  local UTWeapon UTW;

  if (P != None && P.WorldInfo != None) {
    BRPG = class'BattleStaticFunctions'.static.WorldInfo2BatleRPG (P.WorldInfo);  
    UTW = UTWeapon(P.Weapon);
    if (UTW != None && BRPG != None) {
      BW = class'BattleStaticFunctions'.static.ReadWEAP (UTW);
      if (class'BattleStaticFunctions'.static.HasWEAP (UTW)) {
        if (Level==1) {
          if (BW.ActiveBWMLevel == 0) {
            BRPG.CreateWeaponMagic (UTW, BW.ActiveBWM, BW.ActiveBWMLevel, "alwaysmagic");
            class'BattleStaticFunctions'.static.WriteWEAP (UTW, BW);
            class'BattleStaticFunctions'.static.Message2Pawn (P, "newweaponmagic", "Your weapon is now: "@BW.ActiveBWM.MagicDescription (BW.ActiveBWMLevel));
          }
        } else if (Level==2) {
          if (BW.ActiveBWMLevel == 0 || !BW.ActiveBWM.bPositiveMagic) {
            BRPG.CreateWeaponMagic (UTW, BW.ActiveBWM, BW.ActiveBWMLevel, "alwayspositivemagic");
            class'BattleStaticFunctions'.static.WriteWEAP (UTW, BW);
            class'BattleStaticFunctions'.static.Message2Pawn (P, "newweaponmagic", "Your weapon is now: "@BW.ActiveBWM.MagicDescription (BW.ActiveBWMLevel));
          }
        }
      }
    }
  }
}

defaultproperties
{
  AbilityName = "Loaded Magic";
  AbilityDescription = "With level 1 all weapons you use are changed into magic weapons. With level 2 the magic is always positive.";
  AbilityMaxLevel = 2;
  AbilityLevel1Cost = 20;
  AbilityCostIncreasePerLevel = 20;
}