/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_AmmoBonus extends BattleAbility config (BattleRPG);

var float AmmoToAdd;

function RapidServerTimer (UTPawn P, int Level)
{
  if (UTWeapon(P.Weapon) != None && !UTWeapon(P.Weapon).bSuperWeapon) {
    if (UTWeapon(P.Weapon).default.MaxAmmoCount == UTWeapon(P.Weapon).MaxAmmoCount) {
      UTWeapon(P.Weapon).MaxAmmoCount = UTWeapon(P.Weapon).default.MaxAmmoCount * (1.0 + 0.1 * Level);
      UTWeapon(P.Weapon).AddAmmo (0.1 * Level * UTWeapon(P.Weapon).AmmoCount);
    }
  }
}

defaultproperties
{
  AbilityName = "Ammo Bonus";
  AbilityDescription = "Your weapons can hold 10% more ammo per level.";
  AbilityMaxLevel = 10;
  AbilityLevel1Cost = 5;
  AbilityCostIncreasePerLevel = 0;
}