/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/  

class BattleAbility extends Object config (BattleRPG);

// This is dynamic data, the actual data is handled by BattleRPG.uc
var string AbilityName;
var string AbilityDescription;
var int AbilityMaxLevel; // An ability has level 1 .. AbilityMaxLevel.
var int AbilityLevel1Cost; // Cost of the first level.
var int AbilityCostIncreasePerLevel; // Each level can be more expensive than the previous one, or not.

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function DamageFromOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InstigatedByPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function ServerModifyPlayer (UTPawn P, int Level);
function ServerTimer (UTPawn P, int Level);
function RapidServerTimer (UTPawn P, int Level);

function LLDamageToOtherPawn (Pawn P, int Level, int OriginalDamage, out int Damage, Pawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
// function LLDamageFromOtherPawn (Pawn P, int Level, int OriginalDamage, out int Damage, Pawn InstigatedByPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType);
function LLDriverEnteredVehicle (Vehicle V, Pawn P, int Level);
// function LLServerTimer (Pawn P, int Level);
// function LLRapidServerTimer (Pawn P, int Level);

simulated function string Description ()
{
  local string Result;
  local int i;
  local bool AllTheSame;

  Result = AbilityDescription;
  Result = Result @ "Max level:" @ MaxLevel() $ ".";
  if (MaxLevel()==1) {
    Result = Result @ "Cost per level:" @ Cost(1) $ "$.";
  } else {
    AllTheSame = true;
    for (i=2; i<=MaxLevel(); i++) {
      if (Cost(1) != Cost(i)) AllTheSame = false;
    }
    if (AllTheSame) {
      Result = Result @ "Cost per level:" @ Cost(1) $ "$.";
    } else {
      Result = Result @ "Cost per level:" @ Cost(1) $ "$";
      for (i=2; i<=MaxLevel(); i++) {
        Result = Result $ "," @ Cost(i) $ "$";
      }    
      Result = Result $ ".";
    }
  }
  return Result;
}

simulated function int MaxLevel ()
{
  return AbilityMaxLevel;
}

simulated function int TotalCost (int Level)
{
  local int Result;
  local int i;

  for (i=1; i<=Level; i++) Result += Cost (i);
  return Result;
}

simulated function int Cost (int Level)
{
  if (Level > AbilityMaxLevel) return 0;
  if (Level == 1) return AbilityLevel1Cost;
  return AbilityLevel1Cost + (Level - 1) * AbilityCostIncreasePerLevel;
}

defaultproperties
{
  // The default properties are only used by BattleRPG.uc to generate a config from scratch, 
  // after that dynamic ability management takes over.
  AbilityName = "BattleAbilityClass";
  AbilityDescription = "Generic class from which all ability classes are derived.";
  AbilityMaxLevel = 5;
  AbilityLevel1Cost = 5;
  AbilityCostIncreasePerLevel = 5;
}