class Library_Message extends Object;

//------------------------------------------------------------------------------
// Definitions.
//------------------------------------------------------------------------------

// Set this to false to disable debug strings.
const Debug = true;

// Edit this to your preference to make messages stand out among the clutter of
// the log.
const prefix = "|||||||||||||||||||||||||||||| ";
const errorprefix = "### ";

//------------------------------------------------------------------------------
// Public functions (interface for the include file).
//------------------------------------------------------------------------------

// If debugging is enabled, write the message to the log and try to write it to
// the screen.
public static function DebugMessage(Object sender, string message)
{
    if(Debug)
    {
        LogMessage(message);
        ClientMessage(sender, message, true);
    }
}

// If debugging is enabled, write the message to the log and try to write it to
// the screen.
public static function ErrorMessage(Object sender, string message)
{
    if(Debug)
    {
        message = errorprefix $ message;
        LogMessage(message);
        ClientMessage(sender, message, true);
    }
}

// Write the message to the log.
public static function LogMessage(string message)
{
    `log(prefix $ message);
}

// Try to somehow write the message to the screen.
public static function ClientMessage(Object sender, string message, optional bool bAlreadyLogged)
{
    if(Actor(sender) != none)
    {
        ActorClientMessage(Actor(sender), message);
    }
    else if(ActorComponent(sender) != none)
    {
        ActorClientMessage(ActorComponent(sender).Owner, message);
    }
    else
    {
        WorldInfoClientMessage(message, bAlreadyLogged);
    }
}

//------------------------------------------------------------------------------
// Helper functions.
//------------------------------------------------------------------------------

// Write the message to the screen.
private static function ActorClientMessage(Actor sender, string message)
{
    local PlayerController PC;

    foreach sender.LocalPlayerControllers(class'PlayerController', PC)
    {
        PC.ClientMessage(message);
    }
}

// Try to grab the WorldInfo and use that to write the message to the screen.
private static function WorldInfoClientMessage(string message, optional bool bAlreadyLogged)
{
    local WorldInfo wi;

    wi = GetWorldInfo();

    if(wi != none)
    {
        ActorClientMessage(wi, message);
    }
    else
    {
        if(!bAlreadyLogged)
        {
            LogMessage(message);
        }

        LogMessage("Could not send the previous message to clients because WorldInfo was not found.");
    }
}

// Try to grab the WorldInfo.
private static function WorldInfo GetWorldInfo()
{
    return WorldInfo(FindObject("WorldInfo_0", class'WorldInfo'));
}