// The Nemesis works slightly differently:
// - InterpolateCameraScale must also adjust LoweredCameraScale, for when, you
//   guessed it, the Nemesis is lowered.
class CameraControl_Vehicle_Nemesis extends CameraControl_Vehicle_Nemesis_Base
    config(CameraControl);

`include(CameraControl/Classes/Library_Message.uci)

//------------------------------------------------------------------------------
// Events.
//------------------------------------------------------------------------------

simulated event VehicleCalcCamera(float DeltaTime, int SeatIndex, out Vector out_CamLoc, out Rotator out_CamRot, out Vector CamStart, optional bool bPivotOnly)
{
	super.VehicleCalcCamera(DeltaTime, SeatIndex, out_CamLoc, out_CamRot, CamStart, bPivotOnly);

    // Also set crouched mode camera scale.
    LoweredCameraScale = default.LoweredCameraScale * SeatCameraScale;
}

// Adapted from UTVehicle_Nemesis.GetViewRotation.
simulated event Rotator GetViewRotation()
{
    local Rotator FixedRotation;
    local Rotator ControllerRotation;
    local float TimeSinceTransition;
    local float PctTurn;

    if(TurretHeightSetting != THS_Lowered)
    {
        if(bTransitionCameraScale)
        {
            TimeSinceTransition = WorldInfo.TimeSeconds - LastTurretHeightTransitionTime;
            
            if(TimeSinceTransition < FastCamTransitionTime)
            {
                FixedRotation = super.GetViewRotation();
                PctTurn = TimeSinceTransition / FastCamTransitionTime;
                
                FixedRotation.Yaw = PartialTurn(Rotation.Yaw, FixedRotation.Yaw, PctTurn);
                FixedRotation.Pitch = PartialTurn(Rotation.Pitch, FixedRotation.Pitch, PctTurn);
                FixedRotation.Roll = PartialTurn(Rotation.Roll, FixedRotation.Roll, PctTurn);

                return FixedRotation;
            }
        }
        return super(UTVehicle).GetViewRotation();
    }

    // Swing smoothly around to vehicle rotation.
    TimeSinceTransition = WorldInfo.TimeSeconds- LastTurretHeightTransitionTime;

    if(TimeSinceTransition < FastCamTransitionTime)
    {
        FixedRotation = super(UTVehicle).GetViewRotation();
        PctTurn = TimeSinceTransition/FastCamTransitionTime;
        
        FixedRotation.Yaw = PartialTurn(FixedRotation.Yaw, Rotation.Yaw, PctTurn);
        FixedRotation.Pitch = PartialTurn(FixedRotation.Pitch, Rotation.Pitch, PctTurn);
        FixedRotation.Roll = PartialTurn(FixedRotation.Roll, Rotation.Roll, PctTurn);
        
        return FixedRotation;
    }
    else
    {
        if(Controller != none)
        {
			// Average between the vehicle's rotation and the controller's rotation.
			ControllerRotation = (Controller.Rotation + Rotation) * 0.5;
			ControllerRotation.Roll = 0;
            Controller.SetRotation(ControllerRotation);
        }

        return Rotation;
    }
}

simulated event SetInputs(float InForward, float InStrafe, float InUp)
{
    super.SetInputs(InForward, InStrafe, InUp);

	CheckLookSteer(InStrafe);
}

//------------------------------------------------------------------------------
// Looksteer.
//------------------------------------------------------------------------------

private simulated function CheckLookSteer(float InStrafe)
{
	switch(TurretHeightSetting)
	{
		case THS_Lowered:

			// Looksteer if not already steering.
			if(InStrafe == 0)
			{
				LookSteer();
			}

			break;
	}
}

//private simulated function LookSteer()
//{
//	local Rotator SteerRotation, VehicleRotation;
//	local Vector SteerDirection, VehicleDirection;
//	local Vector AngularVelocity;
//	local float VehicleHeading, SteerHeading, DeltaTargetHeading;
//	local float NewSteering;
//	local string message;
//
//	if(IsHumanControlled()
//	&& !WorldInfo.bPlayersOnly)
//	{
//		VehicleRotation.Yaw = Rotation.Yaw;
//		VehicleDirection = vector(VehicleRotation);
//
//		SteerRotation.Yaw = DriverViewYaw;
//		SteerDirection = vector(SteerRotation);
//
//		VehicleHeading = GetHeadingAngle(VehicleDirection);
//		SteerHeading = GetHeadingAngle(SteerDirection);
//		DeltaTargetHeading = FindDeltaAngle(SteerHeading, VehicleHeading);
//
//		if(DeltaTargetHeading > LookSteerDeadZone)
//		{
//			NewSteering = FMin((DeltaTargetHeading - LookSteerDeadZone) * LookSteerSensitivity, 1.0);
//		}
//		else if(DeltaTargetHeading < -LookSteerDeadZone)
//		{
//			NewSteering = FMax((DeltaTargetHeading + LookSteerDeadZone) * LookSteerSensitivity, -1.0);
//		}
//
//		AngularVelocity = Mesh.BodyInstance.GetUnrealWorldAngularVelocity();
//		//NewSteering = FClamp(NewSteering + AngularVelocity.Z * LookSteerDamping, -1.0, 1.0);
//
//		message = "Delta " $ DeltaTargetHeading $ ", Forward " $ ForwardVel $ ", Angular " $ AngularVelocity $ ", Reverse " $ UTVehicleSimHoverTank(SimObj).bWasReversedSteering;
//
//		// Trying to reverse but still sliding forward?
//		if((Throttle < 0
//			&& ForwardVel >= 0)
//		// Reversing but the SimObject is messing up the steering?
//		|| (ForwardVel < 0
//			&& UTVehicleSimHoverTank(SimObj).bWasReversedSteering))
//		{
//			// Reverse steering.
//			message $= " (reversing)";
//			NewSteering = -1.0 * NewSteering;
//		}
//
//		Steering = NewSteering;
//		message $= ", Steering " $ Steering;
//
//		//if(Steering < 0) message $= " (turning right)";
//		//else if (Steering > 0) message $= " (turning left)";
//
//		//if((AngularVelocity.Z > 0) == (Steering < 0) 
//		//&& ForwardVel < 0)
//		//{
//		//	message $= " [fux0rd!?]";
//		//	Steering = -1.0 * Steering;
//		//}
//
//		`ClientMessage(message);
//		DrawDebugLine(Location, Location + 1000000 * vector(VehicleRotation), 0,255,0);
//		DrawDebugLine(Location, Location + 1000000 * vector(SteerRotation), 255,0,0);
//	}
//}

private simulated function LookSteer()
{
	local Rotator SteerRotation, VehicleRotation;
	local Vector SteerDirection, VehicleDirection;
	local float VehicleHeading, SteerHeading, DeltaTargetHeading;

	if(IsHumanControlled())
	{
		VehicleRotation.Yaw = Rotation.Yaw;
		VehicleDirection = vector(VehicleRotation);

		SteerRotation.Yaw = DriverViewYaw;
		SteerDirection = vector(SteerRotation);

		VehicleHeading = GetHeadingAngle(VehicleDirection);
		SteerHeading = GetHeadingAngle(SteerDirection);
		DeltaTargetHeading = FindDeltaAngle(SteerHeading, VehicleHeading);

		if(DeltaTargetHeading > LookSteerDeadZone)
		{
			Steering = FMin((DeltaTargetHeading - LookSteerDeadZone) * LookSteerSensitivity, 1.0);
		}
		else if(DeltaTargetHeading < -LookSteerDeadZone)
		{
			Steering = FMax((DeltaTargetHeading + LookSteerDeadZone) * LookSteerSensitivity, -1.0);
		}

		// Trying to reverse but still sliding forward?  That means the 
		// SimObject's reverse steering won't kick in.
		if((Throttle < 0
			&& ForwardVel >= 0)
		// Reversing but the SimObject is overcompensating?
		|| (ForwardVel < 0
			&& UTVehicleSimHoverTank(SimObj).bWasReversedSteering))
		{
			// Reverse steering.
			Steering = -1.0 * Steering;
		}
	}
 }

//------------------------------------------------------------------------------
// Properties.
//------------------------------------------------------------------------------

defaultproperties
{
    // This way we don't need an extra "Ultra-extreme" setting for lowered mode.
    // Default was 0.35, but with the extra "First Person" setting that kind of
    // close-up can still be achieved.
    LoweredCameraScale=0.7

    Begin Object Class=CameraControl_CameraComponent Name=CameraObject
		// On the hood in mid or raised mode.
		//Offsets(0)=(bFirstPerson=true,FirstPersonBone="TurretBody",FirstPersonOffset=(X=267,Z=6))
		// On the hood in all modes.
		Offsets(0)=(bFirstPerson=true,FirstPersonBone="TurretBody",FirstPersonOffset=(X=240,Z=40))
		// On the right sensor.
		//Offsets(1)=(bFirstPerson=true,FirstPersonBone="SensorPitch",FirstPersonOffset=(X=118,Y=22,Z=-4))
		// On the rear sensor.
		Offsets(1)=(bFirstPerson=true,FirstPersonBone="SensorPitch",FirstPersonOffset=(X=48,Z=4))

		// UT3 style (close).
		Offsets(2)=(Height=0.5,Distance=0.8)
		// UT2004 style (normal).
		Offsets(3)=(Height=1.0,Distance=2.0)
		// Wide.
		Offsets(4)=(Height=1.0,Distance=3.5)
		// Extreme.
		Offsets(5)=(Height=1.0,Distance=5.0)
    End Object
    Camera=CameraObject
    Components.Add(CameraObject)

    // Start at a distance at which nearly the whole craft is visible.
    CameraOffsetIndex=3

	// Move, dammit!
	LookSteerSensitivity=100
	// Tiny dead zone to prevent continual swinging left and right.
	LookSteerDeadZone=0.1//0.001

    HudCoords=(U=257,V=261,UL=90,VL=135)
    ChargeBarPosX=2
    ChargeBarPosY=0
    ChargeBarWidth=10
    ChargeBarHeight=0
}