// TODO: Widescreen support.
// TODO: SPMA should not display the fade while switching to/from first person cameras while deployed (which overrides the camera system).
// TODO: Leviathan turret cam clips while deployed.  Maybe force out of first person while deployed, like Nightshade/Stealthbender.
// TODO: Tweak Stealthbender third person cameras.
// TODO: Tweak Viper third person cameras.
// TODO: Tweak Fury third person cameras.
// TODO: Think about turrets.
// TODO: See about a first person Hoverboard camera.

//==============================================================================
// Camera Control
//------------------------------------------------------------------------------
// Gives mouse wheel control over the vehicle camera distance.
//
// Enables looksteering on the Nemesis in lowered mode.
//
// Provides an alternative SummonV command: mutate <vehiclename>
//==============================================================================
class CameraControl_Mutator extends UTMutator;

`include(CameraControl/Classes/Library_Message.uci)

//------------------------------------------------------------------------------
// Events.
//------------------------------------------------------------------------------

event bool CheckReplacement(Actor Other)
{
    if(UTVehicleFactory(Other) != none)
    {
        return ModifyVehicleFactory(UTVehicleFactory(Other));
    }
    else
    {
        return super.CheckReplacement(Other);
    }
}

event ModifyPlayer(Pawn Other)
{
    if(UTPawn(Other) != none)
    {
        // Replace the hoverboard.
        UTPawn(Other).HoverboardClass = GetVehicleClass("Hoverboard");
    }

    super.ModifyPlayer(Other);
}

// Custom SummonV implementation.
event Mutate(string MutateString, PlayerController Sender)
{
	if(!SummonV(MutateString, Sender))
	{
		super.Mutate(MutateString, Sender);
	}
}

//------------------------------------------------------------------------------
// General.
//------------------------------------------------------------------------------

private function class<UTVehicle> GetVehicleClass(string VehicleName)
{
    return class<UTVehicle>(DynamicLoadObject("CameraControl.CameraControl_Vehicle_" $ VehicleName, class'Class'));
}

//------------------------------------------------------------------------------
// Replacement.
//------------------------------------------------------------------------------

private function bool ModifyVehicleFactory(UTVehicleFactory vf)
{
    switch(vf.VehicleClass)
    {
        case class'UTVehicle_Cicada_Content':

            SetVehicleClass(vf, "Cicada");

            break;

        case class'UTVehicle_Darkwalker_Content':

            SetVehicleClass(vf, "Darkwalker");

            break;

        case class'UTVehicle_Fury_Content':

            SetVehicleClass(vf, "Fury");

            break;

        case class'UTVehicle_Goliath_Content':

            SetVehicleClass(vf, "Goliath");

            break;

        case class'UTVehicle_Hellbender_Content':

            SetVehicleClass(vf, "Hellbender");

            break;

        case class'UTVehicle_Leviathan_Content':

            SetVehicleClass(vf, "Leviathan");

            break;

        case class'UTVehicle_Manta_Content':

            SetVehicleClass(vf, "Manta");

            break;

        case class'UTVehicle_Nemesis':

            SetVehicleClass(vf, "Nemesis");

            break;

        case class'UTVehicle_Nightshade_Content':

            SetVehicleClass(vf, "Nightshade");

            break;

        case class'UTVehicle_Paladin':

            SetVehicleClass(vf, "Paladin");

            break;

        case class'UTVehicle_Raptor_Content':

            SetVehicleClass(vf, "Raptor");

            break;

        case class'UTVehicle_Scavenger_Content':

            SetVehicleClass(vf, "Scavenger");

            break;

        case class'UTVehicle_Scorpion_Content':

            SetVehicleClass(vf, "Scorpion");

            break;

        case class'UTVehicle_SPMA_Content':

            SetVehicleClass(vf, "SPMA");

            break;

        case class'UTVehicle_StealthBenderGold_Content':

            SetVehicleClass(vf, "Stealthbender");

            break;

        case class'UTVehicle_Viper_Content':

            SetVehicleClass(vf, "Viper");

            break;
    }

    // Always true?  Nothing to replace... only modify.
    return true;
}

private function SetVehicleClass(UTVehicleFactory vf, string VehicleName)
{
	local class<UTVehicle> VehicleClass;

	VehicleClass = GetVehicleClass(VehicleName);
    vf.VehicleClassPath = "" $ VehicleClass;
    vf.VehicleClass = VehicleClass;
}

//------------------------------------------------------------------------------
// Console commands.
//------------------------------------------------------------------------------

// Adapted from UTCheatManager.SummonV.
private function bool SummonV(string VehicleName, PlayerController Sender)
{
    local class<Actor> VehicleClass;
    local Vector SpawnLocation;
	local Rotator SpawnRotation;
	local UTVehicle V;

    VehicleClass = GetVehicleClass(VehicleName);

    if(VehicleClass != none)
    {
        if(Sender.Pawn != none)
        {
            SpawnLocation = Sender.Pawn.Location;
			SpawnRotation = Sender.Pawn.Rotation;
        }
        else
        {
            SpawnLocation = Sender.Location;
			SpawnRotation = Sender.Rotation;
        }

        V = UTVehicle(Spawn(VehicleClass,,, SpawnLocation + 72 * Vector(SpawnRotation) + vect(0,0,1) * 15, SpawnRotation));

        if(V != none)
        {
			`log("Fabricate Camera Control " $ VehicleName);

			if(Sender.Pawn != none
			&& UTPawn(Sender.Pawn) != none)
			{
				// Immediately put the player in the vehicle.
				//
				// Or not... since that seems to fux0r some settings... like 
				// steering speed.
				//V.TryToDrive(Sender.Pawn);
			}

			return true;
        }
    }

	return false;
}

//------------------------------------------------------------------------------
// Properties.
//------------------------------------------------------------------------------

defaultproperties
{
    // Do NOT combine this mutator with other vehicle replacement mutators...
    GroupNames[0]="VEHICLES"
}