// HoldItGameReplicationInfo by 3v1LJess aka Jeffrey Bakker 2003

// This structure of this code was based on MutantGameReplicationInfo
// Except this class is replicating the location of the flag, not a Mutant


//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class HoldItGameReplicationInfo extends GameReplicationInfo;

var bool	HeldDown;	// game over
var vector	FlagPos;	// flag position

replication
{
	reliable if(Role == ROLE_Authority)
		FlagPos, HeldDown;
}

function PostBeginPlay()
{
	if(Role == ROLE_Authority)
		SetTimer(0.3, true);
}

function Timer()
{
	local HoldFlag theFlag;

	theFlag  = HoldItDown(Level.Game).HoldIt;

	if(theFlag != None)
	{
		FlagPos = theFlag.Location;
	}
	else {
		FlagPos=vect(-1.1,-1.1,-1.1);
		
		// ^ this is a dummy value for null, since
		// 'None' apparently doesn't work with vectors
	}
	Super.timer();
}

defaultproperties
{
	HeldDown=False
	FlagPos=(x=-1.1,Y=-1.1,Z=-1.1)
}
