// HoldItDown by 3v1LJess aka Jeffrey Bakker 2003

// This gametype is derived from DeathMatch, but
// plays like a mixture of DM, CTF, and original DOM

// It has its own HUD, Scoreboard, Flag, AI, and GRI classes


//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class HoldItDown extends xDeathMatch;

var HoldFlag HoldIt;


function float SpawnWait(AIController B)
{
	if ( B.PlayerReplicationInfo.bOutOfLives )
		return 999;
	if ( Level.NetMode == NM_Standalone )
	{
		if ( HoldSquadAI(Bot(B).Squad).EnemyFlag != None && (Numbots <= 16) )
			return FRand();
		return ( 0.5 * FMax(2,NumBots-4) * FRand() );
	}
	return FRand();
}

function Killed( Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType )
{
	if (HoldIt == None)	// become the flag holder if there is no flag on the map
	{
		HoldIt = Spawn(Class'HoldItDownV11.HoldFlag',Self,,Killer.Pawn.Location);
		HoldIt.SetHolder(Killer);
	}

	else
	if(Killed.PlayerReplicationInfo.HasFlag == HoldIt)
	{
		Killer.AwardAdrenaline(ADR_MajorKill);
		Killer.PlayerReplicationInfo.Score += 4;

		CheckScore(Killer.PlayerReplicationInfo);

	} // reward extra points for killing the flag holder

	Super.Killed(Killer, Killed, KilledPawn, damageType);
}

function DiscardInventory( Pawn Other )
{
	if ( (Other.PlayerReplicationInfo != None) && (Other.PlayerReplicationInfo.HasFlag != None) )
		HoldFlag(Other.PlayerReplicationInfo.HasFlag).Drop(0.5 * Other.Velocity);
	
	Super.DiscardInventory(Other);
}

function InitializeBot(Bot NewBot, UnrealTeamInfo BotTeam, RosterEntry Chosen)
{
	NewBot.InitializeSkill(AdjustedDifficulty);
	class'CustomBotConfig'.static.Customize(Chosen);
	Chosen.InitBot(NewBot);
	BotTeam.AddToTeam(NewBot);

	if ( Chosen.ModifiedPlayerName != "" )
		ChangeName(NewBot, Chosen.ModifiedPlayerName, false);
	else
		ChangeName(NewBot, Chosen.PlayerName, false);

	NewBot.bLeadTarget=true;
	NewBot.bChangeDir=true;
	NewBot.bJumpy=true;
	NewBot.bTacticalDoubleJump=true;

	NewBot.BaseAlertness=1;
	NewBot.Accuracy=0.67;
	NewBot.StrafingAbility=1;
	NewBot.CombatStyle=1;
	NewBot.Tactics=1;
	NewBot.TranslocUse=1;
	NewBot.TranslocFreq=1;
//	NewBot.ReactionTime=1;

	NewBot.Aggressiveness=0.8;
	NewBot.LastAttractCheck=-10000.000000;
	NewBot.BaseAggressiveness=0.6;

	if ( bEpicNames && (NewBot.PlayerReplicationInfo.PlayerName ~= "The_Reaper") )
	{
		NewBot.Accuracy = 1;
		NewBot.StrafingAbility = 1;
		NewBot.Tactics = 1;
		NewBot.InitializeSkill(AdjustedDifficulty+2);
	}

	BotTeam.SetBotOrders(NewBot,Chosen);
}

defaultproperties
{
	HoldIt=None
	GameName="Hold It Down"
	GoalScore=75
	SpawnProtectionTime=3.000000

	DMSquadClass=Class'HoldItDownV11.HoldSquadAI'
	GameReplicationInfoClass=Class'HoldItDownV11.HoldItGameReplicationInfo'
	ScoreBoardType="HoldItDownV11.ScoreBoardHoldIt"
	HUDType="HoldItDownV11.HudHoldItDown"
	MapListType="XInterface.MapListDeathMatch"
	MapPrefix="DM"
	BeaconName="DM"

	NamePrefixes(0)="Mr_"
	NamePrefixes(2)="The_Real_"
	NamePrefixes(3)="Evil_"
	NamePrefixes(5)="Owns_"
	NamePrefixes(7)="Evil_"
	NameSuffixes(1)="IsYourDaddy"
	NameSuffixes(4)="_sucks"
	NameSuffixes(6)="_OwnsYou"
	NameSuffixes(8)="_jr"
	NameSuffixes(9)="'s_Beyatch"
	DMHints(0)="Every weapon has two firing modes, a regular fire mode when you press %FIRE% and an alternate fire mode when you press %ALTFIRE%."
	DMHints(1)="Press jump again at the peak of a jump to get an extra boost."
	DMHints(2)="Pressing a movement key twice in rapid succession will make your character dodge in that direction."
	DMHints(3)="You can also dodge off walls while in the air."
	DMHints(4)="You will score 5 points for killing the flag holder, and 1 point for every 2 seconds that you hold it."
	DMHints(5)="AI (bots) will not shoot at you if someone else is holding the flag."
	DMHints(6)="The flag holder gains 3 adrenaline and 3 health per second, and also infinite Double Damage."
	DMHints(7)="You can toggle the scoreboard display on or off at any time by pressing %SHOWSCORES%. The scoreboard also shows the flag holder with red tint and a marker."
	DMHints(8)="You receive adrenaline for killing enemies and holding the flag.  Once your adrenaline reaches 100, you can start an adrenaline combo by using the correct movement key combination."
	DMHints(9)="%SHOWSTATS% will bring up a personal stats display."
	DMHints(10)="Use your radar on the right to help find the flag or flag holder. If you already have the flag, the radar shows all your enemies."
	DMHints(11)="Press %TALK% and type your message to send text messages to other players."
	DMHints(12)="You can play taunts or other voice messages through the voice menu by pressing %SPEECHMENUTOGGLE%."
	DMHints(13)="While crouching (by holding down %DUCK%), you cannot fall off a ledge."

	Description="Free-for-all. When first blood is drawn, the killer will become the flag holder and have enhanced attributes. Hold the flag as long as possible to gain points...easier said than done when everyone wants to take it from you. It's a little like DM, CTF, and DOM, all in one gametype."
}