// HoldFlag by 3v1LJess aka Jeffrey Bakker 2003, 2004

// This is a modification of the CTFFlag class
// All the code referring to teams has been removed

// This class is specific to the HoldItDown gametype
// The flag will give its holder Udamage, Health,
// Adrenaline, and points

//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class HoldFlag extends GameObject;

#exec OBJ LOAD FILE=XGameShaders.utx
#exec OBJ LOAD FILE=TeamSymbols_UT2003.utx

var bool	HeldDown;

var UnrealPawn 	OldHolder;
var int		Duration;

var HoldItGameReplicationInfo GRI;


simulated function SetGRI(GameReplicationInfo NewGRI)
{
	GRI = HoldItGameReplicationInfo(NewGRI);
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	if ( Level.Game != None )
		SetGRI(Level.Game.GameReplicationInfo);

	LoopAnim('flag',0.8);
	SimAnim.bAnimLoop = true;  
}


// AI

// State transitions
function SetHolder(Controller C)
{
	local HoldSquadAI S;
	
	// AI Related
	if ( Bot(C) != None )
		S = HoldSquadAI(Bot(C).Squad);
	else if ( PlayerController(C) != None )
		S = HoldSquadAI(UnrealTeamInfo(C.PlayerReplicationInfo.Team).AI.FindHumanSquad());
	if ( S != None )
		S.EnemyFlagTakenBy(C);

	Super.SetHolder(C);

	BroadcastLocalizedMessage( MessageClass, 0, Holder.PlayerReplicationInfo, None, None );
//	C.SendMessage(None, 'OTHER', C.GetMessageIndex('GOTENEMYFLAG'), 10, 'GLOBAL');

}

function Drop(vector newVel)
{
	OldHolder = Holder;

	RotationRate.Yaw = Rand(200000) - 100000;
	RotationRate.Pitch = Rand(200000 - Abs(RotationRate.Yaw)) - 0.5 * (200000 - Abs(RotationRate.Yaw));

	Velocity = (0.2 + FRand()) * (newVel + 400 * FRand() * VRand());
	if ( PhysicsVolume.bWaterVolume )
		Velocity *= 0.5;

	Super.Drop(Velocity);
}

function bool ValidHolder(Actor Other)
{
	local Controller c;

	if (!Super.ValidHolder(Other))
		return false;

	c = Pawn(Other).Controller;

	return true;
}

// Events
function Landed(vector HitNormal)
{
	local rotator NewRot;

	NewRot = Rot(16384,0,0);
	NewRot.Yaw = Rotation.Yaw;
	SetRotation(NewRot);
	Super.Landed(HitNormal);
}

// Logging
function LogReturned();

function LogDropped()
{
	BroadcastLocalizedMessage( MessageClass, 2, Holder.PlayerReplicationInfo, None, None ); //Team
	UnrealMPGameInfo(Level.Game).GameEvent("flag_dropped","", Holder.PlayerReplicationInfo);
}

function CheckPain(); // stub

event FellOutOfWorld(eKillZType KillType)
{
	BroadcastLocalizedMessage( MessageClass, 3, None, None, None ); //Team
//	SendHome();
//	Drop(Location);
////
	GoToState('Home');
////
}

// States
auto state Home
{
	ignores SendHome, Score, Drop;
        
	function LogTaken(Controller c)
	{
		BroadcastLocalizedMessage( MessageClass, 6, C.PlayerReplicationInfo, None, None ); //Team
		UnrealMPGameInfo(Level.Game).GameEvent("flag_taken","",C.PlayerReplicationInfo);
	}

	function Timer()
	{
		if ( VSize(Location - HomeBase.Location) > 10 )
		{
			UnrealMPGameInfo(Level.Game).GameEvent("flag_returned_timeout","",None);
			BroadcastLocalizedMessage( MessageClass, 3, None, None, None ); //Team
			log(self$" Home.Timer: had to sendhome", 'Error');
//			SendHome();
////?
			BeginState();
////
		}
	}

	function BeginState()
	{
		Super.BeginState();

		// resets the flag
		HoldItDown(Level.Game).HoldIt.Destroy();
		HoldItDown(Level.Game).HoldIt = None;

		bHidden = true;
		SetTimer(1.0, true);
	}

	function EndState()
	{
		Super.EndState();
		bHidden = false;
		SetTimer(0.0, false);
	}
}

state Held
{
	ignores SetHolder, SendHome;

	function Timer()
	{
		if(GRI.HeldDown)	// don't execute if game ended
			return;

		Duration++;

		if (Duration >= 20 && Holder == None)
		{
			log(self$" Held.Timer: had to sendhome", 'Error');
			UnrealMPGameInfo(Level.Game).GameEvent("flag_returned_timeout","",None);
			BroadcastLocalizedMessage( MessageClass, 3, None, None, None ); //Team
//			SendHome();
////
			GoToState('Home');
////
		}

		else
		{
			if(Duration % 2 == 0)	// score a point every 2 seconds
			{
				if(Holder.Controller.PlayerReplicationInfo.Score >= HoldItDown(Level.Game).GoalScore)
				{
					if(!GRI.HeldDown)
					{
						GRI.HeldDown = true;
						HoldItDown(Level.Game).CheckScore(Holder.Controller.PlayerReplicationInfo);

						return;
					}
				}
				else	Holder.Controller.PlayerReplicationInfo.Score += 1;
			}


			// make the flag holder harder to stop

			Holder.Controller.AwardAdrenaline(3);
			Holder.EnableUDamage(31);

			if(Holder.Health < Holder.HealthMax)
				Holder.Health += Min(5,Holder.HealthMax - Holder.Health);
		}
	}

	function BeginState()
	{
		Super.BeginState();
		SetTimer(1.0, true);
	}

	function EndState()
	{
		Holder.DisableUDamage();
		Super.EndState();
	}
}

state Dropped
{
	ignores Drop;

	function LogTaken(Controller c)
	{
		UnrealMPGameInfo(Level.Game).GameEvent("flag_pickup","",C.PlayerReplicationInfo);
		BroadcastLocalizedMessage( MessageClass, 4, C.PlayerReplicationInfo, None, None ); //Team
	}

	function CheckFit()
	{
		local vector X,Y,Z;
		GetAxes(OldHolder.Rotation, X,Y,Z);
		SetRotation(rotator(-1 * X));
		if ( !SetLocation(OldHolder.Location - 2 * OldHolder.CollisionRadius * X + OldHolder.CollisionHeight * vect(0,0,0.5)) 
			&& !SetLocation(OldHolder.Location) )
		{
			SetCollisionSize(0.8 * OldHolder.CollisionRadius, FMin(CollisionHeight, 0.8 * OldHolder.CollisionHeight));
			if ( !SetLocation(OldHolder.Location) )
			{
				//log(self$" Drop sent flag home", 'Error');
				UnrealMPGameInfo(Level.Game).GameEvent("flag_returned_timeout","",None);
				BroadcastLocalizedMessage( MessageClass, 3, None, None, None ); //Team
//				SendHome();
////?
				GoToState('Home');
////
				return;
			}
		}
	}

	function CheckPain()
	{
		if (IsInPain())
			timer();
	}

	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, Vector momentum, class<DamageType> damageType)
	{
		CheckPain();
	}

	singular function PhysicsVolumeChange( PhysicsVolume NewVolume )
	{
		Super.PhysicsVolumeChange(NewVolume);
		CheckPain();
	}

	function BeginState()
	{
		Super.BeginState();
		bCollideWorld = true;
		SetCollisionSize(0.5 * default.CollisionRadius, CollisionHeight);
		SetCollision(true, false, false);
		CheckFit();
		CheckPain();
		SetTimer(MaxDropTime, false);
	}
    
	function EndState()
	{
		Super.EndState();
		bCollideWorld = false;
		SetCollisionSize(default.CollisionRadius, default.CollisionHeight);
	}
	
	function Timer()
	{
		BroadcastLocalizedMessage( MessageClass, 3, None, None, None );
		UnrealMPGameInfo(Level.Game).GameEvent("flag_returned_timeout","",None);
		Super.Timer();
	}
}

defaultproperties
{
	Duration=0
	MaxDropTime=30

	bReplicateMovement=True
	bAlwaysRelevant=True
	bNetNotify=True
	bHome=True
	LightType=LT_Steady
	LightEffect=LE_QuadraticNonIncidence
	LightBrightness=128.000000
	LightRadius=6.000000
	LightSaturation=128
	bStatic=False
	bHidden=False
	bDynamicLight=True
	bStasis=False
	NetPriority=3.000000
	DrawType=DT_Mesh
	Mesh=VertMesh'XGame_rc.FlagMesh'
	DrawScale=0.900000
	Skins(0)=FinalBlend'XGameShaders.RedFlagShader_F'
	PrePivot=(X=2.000000,Z=0.500000)
	Style=STY_Masked
	bUnlit=True
	CollisionRadius=48.000000
	CollisionHeight=30.000000
	bCollideActors=True
	bCollideWorld=True
	bFixedRotationDir=True
	Mass=30.000000
	Buoyancy=20.000000
	RotationRate=(Pitch=30000,Roll=30000)

	MessageClass=Class'HoldItDownV11.FlagMessage'
}
