// FlagMessage by 3v1LJess aka Jeffrey Bakker 2003

// This is a modification of the CTFMEssage class
// All the code referring to teams has been removed


//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class FlagMessage extends CriticalEventPlus;

#exec OBJ LOAD FILE=GameSounds.uax

var(Message) localized string ReturnedFlag;
var(Message) localized string CaptureFlag;
var(Message) localized string DroppedFlag;
var(Message) localized string HasFlag;

var sound	ReturnSound;
var sound	DroppedSound;
var Sound	TakenSound;
var sound	Riffs[3];

static simulated function ClientReceive( 
	PlayerController P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);

	switch (Switch)
	{
		case 0:
			P.ClientPlaySound(Default.Riffs[Rand(3)]);
			break;
		// Returned the flag.
		case 1:
		case 3:
		case 5:
			P.PlayAnnouncement(default.ReturnSound,2, true);
			break;

		// Dropped the flag.
		case 2:
			P.PlayAnnouncement(default.DroppedSound,2, true);
			break;
		case 4:
		case 6:
			P.PlayAnnouncement(default.TakenSound,2, true);
			break;
	}
}

static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{

	switch (Switch)
	{
		// Captured the flag.
		case 0:
			if (RelatedPRI_1 == None)
				return "";

			return RelatedPRI_1.PlayerName@Default.CaptureFlag@RelatedPRI_1.playername$"!!";
			break;

		// Returned the flag.
		case 1:
			if (RelatedPRI_1 == None)
			{
				return Default.ReturnedFlag;
			}
			return RelatedPRI_1.playername@Default.ReturnedFlag;
			break;

		// Dropped the flag.
		case 2:
			if (RelatedPRI_1 == None)
				return "";

			return RelatedPRI_1.playername@Default.DroppedFlag;
			break;

		// Was returned.
		case 3:
			return Default.ReturnedFlag;
			break;

		// Has the flag.
		case 4:
			if (RelatedPRI_1 == None)
				return "";
			return RelatedPRI_1.playername@Default.HasFlag@RelatedPRI_1.playername$"!!";
			break;

		// Auto send home.
		case 5:
			return Default.ReturnedFlag;
			break;

		// Pickup
		case 6:
			if (RelatedPRI_1 == None)
				return "";
			return RelatedPRI_1.playername@Default.HasFlag@RelatedPRI_1.playername$"!!";
			break;
	}
	return "";
}

defaultproperties
{
	Lifetime=6

	ReturnedFlag="The flag was reset!"
	CaptureFlag="took the flag! Kill"
	DroppedFlag="dropped the flag!"
	HasFlag="took the flag! Kill"

	ReturnSound=Sound'AnnouncerMain.red_flag_returned'
	DroppedSound=Sound'AnnouncerMain.red_flag_dropped'
	TakenSound=Sound'AnnouncerMain.red_flag_taken'
	Riffs(0)=Sound'GameSounds.Fanfares.UT2K3Fanfare01'
	Riffs(1)=Sound'GameSounds.Fanfares.UT2K3Fanfare04'
	Riffs(2)=Sound'GameSounds.Fanfares.UT2K3Fanfare06'
	StackMode=SM_Down
	PosY=0.120000
}
