// HudHoldItDown by 3v1LJess aka Jeffrey Bakker 2003, 2004

// Most of the radar code was taken from HUDInvasion, and
// then modified to dispaly the flag location and appearance

// The look and feel of the HUD has been updated for ut2004,
// including support for custom HUD colors for HoldItDown info
// Also added a portrait of the current target


//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class HudHoldItDown extends HudCDeathMatch;

#EXEC OBJ LOAD FILE=InterfaceContent.utx
#EXEC OBJ LOAD FILE=2k4Hud.utx

var Material MugShot;

var float RadarPulse,RadarScale;
var config float RadarPosX, RadarPosY;
var float LastDrawRadar;

var config bool bNoRadarSound;
var color myHUDWhite;
var color myBlue;

simulated function DrawHudPassA(Canvas C)
{
	local float PulseWidth; //RadarWidth, PulseWidth, PulseBrightness;
	local Pawn P;
	local vector FlagHeld;
	local float Dist, MaxDist, RadarWidth, PulseBrightness,Angle,DotSize,OffsetY,OffsetScale;
	local rotator Dir;
	local vector Start;
//	local Material HolderMug;

	local HoldItGameReplicationInfo HoldItInfo;
	HoldItInfo = HoldItGameReplicationInfo(PlayerOwner.GameReplicationInfo);

	Super.DrawHudPassA(C);

	RadarScale = Default.RadarScale * HUDScale;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	PulseWidth = RadarScale * C.ClipX;

	if(bUsingCustomHUDColor)
		C.DrawColor = CustomHUDColor;
	else	C.DrawColor = HudColorBlue;

	C.Style = ERenderStyle.STY_Translucent;

	PulseBrightness = FMax(0,(1 - 2*RadarPulse) * 255.0);
//	C.DrawColor.R = PulseBrightness;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile( Material'InterfaceContent.SkinA', PulseWidth, PulseWidth, 0, 880, 142, 142);

	PulseWidth = RadarPulse * RadarScale * C.ClipX;
	if(bUsingCustomHUDColor)
		C.DrawColor = CustomHUDColor;
	else	C.DrawColor = HudColorBlue;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile( Material'InterfaceContent.SkinA', PulseWidth, PulseWidth, 0, 880, 142, 142);

//	C.DrawColor = WhiteColor;
	if(bUsingCustomHUDColor)
		C.DrawColor = CustomHUDColor;
	else	C.DrawColor = HudColorBlue;
	C.SetPos(RadarPosX*C.ClipX - RadarWidth,RadarPosY*C.ClipY+RadarWidth);
	C.DrawTile( Shader'RDM_InnerScopeShader', RadarWidth, RadarWidth, 0, 512, 512, -512);
	C.SetPos(RadarPosX*C.ClipX,RadarPosY*C.ClipY+RadarWidth);
	C.DrawTile( Shader'RDM_InnerScopeShader', RadarWidth, RadarWidth, 512, 512, -512, -512);
	C.SetPos(RadarPosX*C.ClipX - RadarWidth,RadarPosY*C.ClipY);
	C.DrawTile( Shader'RDM_InnerScopeShader', RadarWidth, RadarWidth, 0, 0, 512, 512);
	C.SetPos(RadarPosX*C.ClipX,RadarPosY*C.ClipY);
	C.DrawTile( Shader'RDM_InnerScopeShader', RadarWidth, RadarWidth, 512, 0, -512, 512);


	LastDrawRadar = Level.TimeSeconds;
	DotSize = 24*C.ClipX*HUDScale/1600;

	if ( PawnOwner == None ) {

		Start = PlayerOwner.Location;
	}
	else {
		Start = PawnOwner.Location;
	}

	FlagHeld = HoldItInfo.FlagPos;

	MaxDist = 3000 * RadarPulse;
	OffsetY = RadarPosY + RadarWidth/C.ClipY;


	// draw location of enemies if you have the flag
	if(PawnOwner.Controller.PlayerReplicationInfo.HasFlag != None)
	{
		ForEach DynamicActors(class'Pawn',P)

		if ( P.Health > 0 )
		{
			Dist = VSize(Start - P.Location);
			if ( Dist < 3000 )
			{
				if ( Dist < MaxDist )
					PulseBrightness = 255 - 255*Abs(Dist*0.00033 - RadarPulse);
				else
					PulseBrightness = 255 - 255*Abs(Dist*0.00033 - RadarPulse - 1);

				if(bUsingCustomHUDColor)
					C.DrawColor = CustomHUDColor;
				else
				{
					C.DrawColor.B = PulseBrightness;
					C.DrawColor.G = 0;
					C.DrawColor.R = 0;
				}

				Dir = rotator(P.Location - Start);
				OffsetScale = RadarScale*Dist*0.000167;
				Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832/65536;
				C.SetPos(RadarPosX * C.ClipX + OffsetScale * C.ClipX * sin(Angle) - 0.5*DotSize,
				OffsetY * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5*DotSize);
				C.DrawTile(Material'InterfaceContent.Hud.SkinA',DotSize,DotSize,838,238,144,144);
			}
		}
		return;			
	}

	// dummy value for null, since 'None'
	// apparently doesn't work with vectors

	if(FlagHeld == vect(-1.1,-1.1,-1.1))
		return;

	// draw location of the flag itself
	Dist = VSize(Start - FlagHeld);
	if ( Dist < 3000 )
	{
		if ( Dist < MaxDist )
			PulseBrightness = 255 - 255*Abs(Dist*0.00033 - RadarPulse);
		else
			PulseBrightness = 255 - 255*Abs(Dist*0.00033 - RadarPulse - 1);

		C.DrawColor.R = PulseBrightness;
		C.DrawColor.G = PulseBrightness;
		C.DrawColor.B = PulseBrightness;


		Dir = rotator(FlagHeld - Start);
		OffsetScale = RadarScale*Dist*0.000167;
		Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832/65536;
		C.SetPos(RadarPosX * C.ClipX + OffsetScale * C.ClipX * sin(Angle) - 0.5*DotSize,
		OffsetY * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5*DotSize);
		C.DrawTile(Material'InterfaceContent.Hud.SkinA',DotSize,DotSize,838,238,144,144);
	}
}

simulated function DrawHudPassC (Canvas C)
{
	local Pawn P;
	local Material HolderMug;

	Super.DrawHudPassC(C);


	if(PawnOwner.Controller.PlayerReplicationInfo.HasFlag != None)
		return;

	C.Style = ERenderStyle.STY_Translucent;

	if(bUsingCustomHUDColor)
		C.DrawColor = CustomHUDColor;
	else	C.DrawColor = myHUDWhite;

	// Draw the name and portrait of the Target (flagholder)
	ForEach DynamicActors(class'Pawn',P)

	if ( P.PlayerReplicationInfo.HasFlag != None )
	{
		if(P != PawnOwner)
		{
			C.Font = GetFontSizeIndex(C,-5);

			HolderMug = P.PlayerReplicationInfo.GetPortrait();
			if(HolderMug != None)
				MugShot = HolderMug;

			C.SetPos(12,128);
			C.DrawText("Target:"@P.PlayerReplicationInfo.PlayerName);
			C.SetPos(12,136);

			if(MugShot == None) {
				C.DrawText("No Portrait");
			}
			else {
				C.DrawTile(MugShot, 128, 256, 0, 0, 256, 512);
			}
		}
	}
}

defaultproperties
{
	HudColorBlue=(B=232,G=22,R=12,A=255)
	HudColorTeam(1)=(B=232,G=22,R=12,A=255)
	myHUDWhite=(B=200,G=200,R=200,A=255)

	// Radar
	RadarScale=0.200000
	RadarPosX=0.900000
	RadarPosY=0.250000

	// Strings
	YouveWonTheMatch="You've held it down!"
	YouveLostTheMatch="You've lost the match."
	WonMatchPostFix=" held it down!"
}
