// HoldSquadAI by 3v1LJess aka Jeffrey Bakker 2003

// This is a modification of the CTFSquadAI class
// All the code referring to teams has been removed
// No GameObjective code, homebase code, or assault path

// It is derived from DMSquad to inherit functions
// that haven't been overrided

//	New or modified code (C)2003, 2004 Jeffrey Bakker <evil@damnclan.com>
//	Existing code for Unreal  Tournament 2004 Copyright  2004 Epic Games, Inc.


//	Hold It Down - An all new gametype for UT2004
//	Copyright (C)2003, 2004  Jeffrey Bakker

//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.

//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.

//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class HoldSquadAI extends DMSquad;

var HoldFlag EnemyFlag;
var float LastSeeFlagCarrier;


function PostBeginPlay()
{
	if(Role == ROLE_Authority)
		SetTimer(3.0, true);
}

function Timer()
{
	EnemyFlag = HoldItDown(Level.Game).HoldIt;

	Super.timer();
}

//function actor SetFacingActor(Bot B)
//{
//	return EnemyFlag;
//}

function bool AllowDetourTo(Bot B,NavigationPoint N)
{
	if ( B.Pawn != EnemyFlag.Holder )
		return true;

	return ( B.RouteDist > 1000 );
}

function bool FindPathToObjective(Bot B, Actor O)
{
	if ( (EnemyFlag.Holder != B.Pawn) )
		return Super.FindPathToObjective(B, O);

	B.MoveTarget = O;
	if ( B.ActorReachable(O) )
	{
		if ( B.Pawn.ReachedDestination(O) )
		{
			O.Touch(B.Pawn);
			return false;
		}
		B.RouteGoal = O;
		B.RouteCache[0] = None;
		B.GoalString = B.GoalString@"almost at "$O;
		B.MoveTarget = O;
		B.bFinalStretch = true;
		B.SetAttractionState();
		return true;
	}

//	B.FindBestPathToward(O,true,true);

	return B.StartMoveToward(O);
}

function bool AllowTranslocationBy(Bot B)
{
	return ( B.Pawn != EnemyFlag.Holder );
}

function bool GoPickupFlag(Bot B)
{
	if ( FindPathToObjective(B,EnemyFlag) )
	{
		B.GoalString = "Pickup enemy flag";
		return true;
	}
	return false;
}

/* OrdersForFlagCarrier()
Tell bot what to do if he's carrying the flag
*/	
function bool OrdersForFlagCarrier(Bot B)
{
	if ( (B.Pawn.Health < 40) || (FRand() < 0.2) )
		B.TryCombo("xGame.ComboDefensive");
	else
		B.TryCombo("xGame.ComboSpeed");


	if ( EnemyFlag.Holder == None
		&& B.LineOfSightTo(EnemyFlag.Position())  
		&& (VSize(B.Pawn.Location - EnemyFlag.Location) < 1500.f) 
		&& GoPickupFlag(B) )

		return true;

//	if(B.PickRetreatDestination()) B.DoRetreat();

	B.FightEnemy(true,0);

//	B.WanderOrCamp(false);

	return true;
}

function bool CheckSquadObjectives(Bot B)
{
	local bool bSeeFlag;
	local actor FlagCarrierTarget;
	local controller FlagCarrier;

	if ( EnemyFlag.Holder == B.Pawn )
		return OrdersForFlagCarrier(B);

	AddTransientCosts(B,1);

	bSeeFlag = B.LineOfSightTo(EnemyFlag.Position());

	if(bSeeFlag)
	{
		if ( EnemyFlag.Holder == None ) 
		{
			if ( GoPickupFlag(B) )
				return true;
		}
		else {

			if ( B.Enemy != EnemyFlag.Holder )
				FindNewEnemyFor(B,(B.Enemy != None) && B.LineOfSightTo(B.Enemy));

			if ( B.IsSniping() )
				return false;

			B.bPursuingFlag = true;
			return ( TryToIntercept(B,EnemyFlag.Holder,EnemyFlag) );
		}
	}

	if ( GetOrders() == 'Attack' )
	{
		// break off attack only if needed
		if ( B.bPursuingFlag || bSeeFlag )
		{
			B.bPursuingFlag = true;
			B.GoalString = "Go after enemy holding flag rather than attacking";
			if ( EnemyFlag.Holder != None )
				return TryToIntercept(B,EnemyFlag.Holder,EnemyFlag);
			else if ( GoPickupFlag(B) )
				return true;
		
		}
	}

	B.bPursuingFlag = false;

	if ( EnemyFlag.Holder == None )
	{
		B.GoalString = "Near enemy flag!";
		return FindPathToObjective(B,EnemyFlag.Position());
	}

	else
	if(GetOrders() != 'Defend')
	{

		if ( (B.Enemy != None) && (B.Enemy == EnemyFlag.Holder) )
		{
			B.GoalString = "Fight enemy threatening flag carrier";
			B.FightEnemy(true,0);
			return true;
		}

		FindPathToObjective(B, EnemyFlag);
	}

//	B.GoalString = "Find the flag carrier - move to "$B.MoveTarget;
//	return ( B.MoveTarget != None );

	return Super.CheckSquadObjectives(B);
}

function bool ShouldDeferTo(Controller C)
{
//	if ( C.PlayerReplicationInfo.HasFlag != None )
//		return true;

	return Super.ShouldDeferTo(C);
}

function EnemyFlagTakenBy(Controller C)
{
	local Bot M;

	if ( (PlayerController(SquadLeader) == None) && (SquadLeader != C) )
		SetLeader(C);

	for	( M=SquadMembers; M!=None; M=M.NextSquadMember )
		if ( (M.MoveTarget == EnemyFlag) )
			M.MoveTimer = FMin(M.MoveTimer,0.05 + 0.15 * FRand());
}

function bool SetEnemy( Bot B, Pawn NewEnemy )
{
	if( EnemyFlag.Holder == B.Pawn )	// everyone's an enemy if you have the flag
		return AddEnemy(NewEnemy);

	if( EnemyFlag.Holder == None )		// everyone's an enemy if nobody has the flag
		return AddEnemy(NewEnemy);

	if( NewEnemy != EnemyFlag.Holder )	// go after the flag holder exclusively
		return false;

	if ( !AddEnemy(NewEnemy) )		// default
		return false;

	return FindNewEnemyFor(B,(B.Enemy !=None) && B.LineOfSightTo(SquadMembers.Enemy));
}

// structure taken from Mutant AI code
// looks for flagholder instead of mutant
function bool FindNewEnemyFor(Bot B, bool bSeeEnemy)
{
	local Pawn OldEnemy, HolderPawn;

	if( EnemyFlag.Holder == B.Pawn )
		return Super.FindNewEnemyFor(B, bSeeEnemy);

	// normal DM if there is no flag holder
	if( EnemyFlag.Holder == None )
		return Super.FindNewEnemyFor(B, bSeeEnemy);

	OldEnemy = B.Enemy;
	
	HolderPawn = EnemyFlag.Holder;

	if(HolderPawn != None)
	{
		if ( VSize(HolderPawn.Location - B.Pawn.Location) < 1500 )
			bSeeEnemy = B.LineOfSightTo(HolderPawn);
		else
			bSeeEnemy = B.CanSee(HolderPawn);	// only if looking at him
	}
	B.Enemy = HolderPawn;

	if(OldEnemy != HolderPawn)
	{
		B.EnemyChanged(bSeeEnemy);
		return true;
	}

	return false;
}

function NotifyKilled(Controller Killer, Controller Killed, pawn KilledPawn)
{
	local Bot B;
//	local Bot M;

	if ( Killed == None )
		return;

	RemoveEnemy(KilledPawn);

	B = Bot(Killer);
	if ( (B != None) && (B.Squad == self) && (B.Enemy == None) && (B.Pawn != None) && AllowTaunt(B) )
	{
		B.Target = KilledPawn;
		B.Celebrate();
	}

//	for( M=SquadMembers; M!=None; M=M.NextSquadMember )
//	{
//		M.MoveTarget = EnemyFlag;
//	}
}

function bool AllowTaunt(Bot B)
{
	return ( (FRand() < 0.5) && (PriorityObjective(B) < 1));
}

function byte PriorityObjective(Bot B)
{
	if ( B.PlayerReplicationInfo.HasFlag != None )
	{
		return 255;
	}

	if ( EnemyFlag.Holder != None )
		return 2;

	return 0;
}

function float ModifyThreat(float current, Pawn NewThreat, bool bThreatVisible, Bot B)
{
	if ( (NewThreat.PlayerReplicationInfo != None)
		&& (NewThreat.PlayerReplicationInfo.HasFlag != None)
		&& bThreatVisible )
	{
		if ( (VSize(B.Pawn.Location - NewThreat.Location) < 1500) )
			return current + 6;
		else
			return current + 1.5;
	}
	else if ( NewThreat.IsHumanControlled() )
		return current + 0.5;
	else
		return current;
}

defaultproperties
{
}
