//===========================================================
// replace any weapon with the ripjack
//
//===========================================================

class MutRipjack extends Mutator
    config(Ripjack);

var() config string ReplacedWeaponClassName;
var() config bool bConfigUseRipjack;
var() byte bUseRipjack;
var class<Weapon> ReplacedWeaponClass;
var class<WeaponPickup> ReplacedWeaponPickupClass;
var class<Ammo> ReplacedAmmoPickupClass;
var class<Weapon> RipjackWeaponClass;
var string RipjackWeaponPickupClassName;
var string RipjackAmmoPickupClassName;
var localized string DisplayText, DescText, DisplayTextB, DescTextB;

function PostBeginPlay()
{
	local int FireMode;
	local string ReplacedWeaponPickupClassName;


	bUseRipjack = byte(bool(GetPropertyText("bConfigUseRipjack")));
	ReplacedWeaponClass =  class<Weapon>(DynamicLoadObject(GetPropertyText("ReplacedWeaponClassName"),class'Class'));
		ReplacedWeaponPickupClassName = string(ReplacedWeaponClass.default.PickupClass);
		for(FireMode = 0; FireMode<2; FireMode++)
		{
			if( (ReplacedWeaponClass.default.FireModeClass[FireMode] != None)
			 && (ReplacedWeaponClass.default.FireModeClass[FireMode].default.AmmoClass != None)
			 && (ReplacedWeaponClass.default.FireModeClass[FireMode].default.AmmoClass.default.PickupClass != None) )
			{
				ReplacedAmmoPickupClass = class<Ammo>(ReplacedWeaponClass.default.FireModeClass[FireMode].default.AmmoClass.default.PickupClass);
				break;
			}
		}
		RipjackWeaponPickupClassName = string(RipjackWeaponClass.default.PickupClass);

	Super.PostBeginPlay();
}

function bool CheckReplacement( Actor Other, out byte bSuperRelevant )
{
	local int i;
	local WeaponLocker L;

	bSuperRelevant = 0;
	if (xWeaponBase(Other) != None)
	{
		if (bUseRipjack == 1 && xWeaponBase(Other).WeaponType == ReplacedWeaponClass)
			xWeaponBase(Other).WeaponType = RipjackWeaponClass;
	}
	else if (Weapon(Other) != None)
	{
		if ( Other.IsA('BallLauncher') )
        		return true;
		if (bUseRipjack == 1 && Other.Class == ReplacedWeaponClass)
			return false;
 	}
	else if (WeaponPickup(Other) != None)
	{
		if (bUseRipjack == 1 && Other.Class == ReplacedWeaponPickupClass)
		{
			ReplaceWith(Other, RipjackWeaponPickupClassName);
			return false;
		}
	}
	else if (Ammo(Other) != None)
	{
		if (bUseRipjack == 1 && Other.Class == ReplacedAmmoPickupClass)
		{
			ReplaceWith(Other, RipjackAmmoPickupClassName);
			return false;
		}
	}
	else if (WeaponLocker(Other) != None)
	{
		L = WeaponLocker(Other);
		if (bUseRipjack == 1)
			for (i = 0; i < L.Weapons.Length; i++)
				if (L.Weapons[i].WeaponClass == ReplacedWeaponClass)
					L.Weapons[i].WeaponClass = RipjackWeaponClass;
	}

        return true;
}

function string GetInventoryClassOverride(string InventoryClassName)
{
	if (InventoryClassName ~= string(ReplacedWeaponClass))
		return string(RipjackWeaponClass);

	return Super.GetInventoryClassOverride(InventoryClassName);
}


static function FillPlayInfo(PlayInfo PlayInfo)
{
	local array<CacheManager.WeaponRecord> Recs;
	local string WeaponOptions;
	local int i;

	Super.FillPlayInfo(PlayInfo);

	class'CacheManager'.static.GetWeaponList(Recs);
	for (i = 0; i < Recs.Length; i++)
	{
		if (WeaponOptions != "")
			WeaponOptions $= ";";

		WeaponOptions $= Recs[i].ClassName $ ";" $ Recs[i].FriendlyName;
	}

	PlayInfo.AddSetting(default.RulesGroup, "bConfigUseRipjack", default.DisplayText, 0, 1, "Check");
	PlayInfo.AddSetting(default.RulesGroup, "ReplacedWeaponClassName", default.DisplayTextB, 0, 1, "Select", WeaponOptions);

	PlayInfo.SaveSettings();
}

static event string GetDescriptionText(string PropName)
{
	if (PropName == "bConfigUseRipjack")
		return default.DescText;
	if (PropName == "ReplacedWeaponClassName")
		return default.DescText;

	return Super.GetDescriptionText(PropName);
}

defaultproperties
{
    GroupName="Arena"
    IconMaterialName="MutatorArt.nosym"
    FriendlyName="Ripjack Replacer"
    Description="Replace a weapon of your choice with the Ripjack."
    ReplacedWeaponClassName="XWeapons.Minigun"
    bConfigUseRipjack=0
    RipjackWeaponClass=class'Ripjack.Ripjack'
    RipjackAmmoPickupClassName="Ripjack.RipjackAmmoPickup"
    DisplayText="Add the Ripjack"
    DisplayTextB="Replace this with the Ripjack"
    DescText="Choose if the Ripjack will be added to the game"
    DescTextB="Replace this weapon with the Ripjack"
}
