//==================================================
// RipjackPickup
//
// Author: Radiosity
//==================================================

class RipjackPickup extends UTWeaponPickup;

#exec OBJ LOAD FILE=ripjackTex.utx
#exec OBJ LOAD FILE=ripjackAnim.ukx
#exec OBJ LOAD FILE=ripjackSM.usx
#exec OBJ LOAD FILE=ripjackSounds.uax

static function StaticPrecache(LevelInfo L)
{
	L.AddPrecacheMaterial(Texture'ripjackTex.trailtex_desat');
	L.AddPrecacheMaterial(Texture'ripjackTex.Ripjack_explode');
	L.AddPrecacheMaterial(Texture'ripjackTex.RipjackCube');
	L.AddPrecacheMaterial(Texture'ripjackTex.RipjackExplodeTiles');
	L.AddPrecacheMaterial(Texture'ripjackTex.RipjackSkinb');
	L.AddPrecacheMaterial(Texture'ripjackTex.RipjackFragment');
	L.AddPrecacheMaterial(Texture'ripjackTex.RipBladeSkinb');
	L.AddPrecacheMaterial(Texture'AW-2004Particles.Energy.SparkHead');
	L.AddPrecacheMaterial(Texture'AW-2004Particles.Energy.EclipseCircle');
	L.AddPrecacheMaterial(Texture'EpicParticles.Flares.SoftFlare');
	L.AddPrecacheMaterial(Texture'EpicParticles.Flares.FlashFlare1');
	L.AddPrecacheMaterial(Texture'AW-2004Particles.Weapons.PlasmaFlare');
	L.AddPrecacheMaterial(Texture'AW-2004Particles.MuchSmoke2t');
	L.AddPrecacheMaterial(Texture'AW-2004Particles.SmallBang');
	L.AddPrecacheStaticMesh(StaticMesh'ripjackSM.RipjackPickupMesh');
	L.AddPrecacheStaticMesh(StaticMesh'ripjackSM.RipjackAmmoPickup');
}

simulated function UpdatePrecacheMaterials()
{
	Level.AddPrecacheMaterial(Texture'ripjackTex.trailtex_desat');
	Level.AddPrecacheMaterial(Texture'ripjackTex.Ripjack_explode');
	Level.AddPrecacheMaterial(Texture'ripjackTex.RipjackCube');
	Level.AddPrecacheMaterial(Texture'ripjackTex.RipjackExplodeTiles');
	Level.AddPrecacheMaterial(Texture'ripjackTex.RipjackSkinb');
 	Level.AddPrecacheMaterial(Texture'ripjackTex.RipjackFragment');
	Level.AddPrecacheMaterial(Texture'ripjackTex.RipBladeSkinb');
	Level.AddPrecacheMaterial(Texture'AW-2004Particles.Energy.SparkHead');
	Level.AddPrecacheMaterial(Texture'AW-2004Particles.Energy.EclipseCircle');
	Level.AddPrecacheMaterial(Texture'EpicParticles.Flares.SoftFlare');
	Level.AddPrecacheMaterial(Texture'EpicParticles.Flares.FlashFlare1');
	Level.AddPrecacheMaterial(Texture'AW-2004Particles.Weapons.PlasmaFlare');
	Level.AddPrecacheMaterial(Texture'AW-2004Particles.MuchSmoke2t');
	Level.AddPrecacheMaterial(Texture'AW-2004Particles.SmallBang');

	super.UpdatePrecacheMaterials();
}

simulated function UpdatePrecacheStaticMeshes()
{
	Level.AddPrecacheStaticMesh(StaticMesh'ripjackSM.RipjackPickupMesh');
	Level.AddPrecacheStaticMesh(StaticMesh'ripjackSM.RipjackAmmoPickup');
	Super.UpdatePrecacheStaticMeshes();
}

defaultproperties
{
	InventoryType=class'Ripjack.Ripjack'

	PickupMessage="You got the Ripjack."
	PickupSound=Sound'ripjackSounds.Ripjack_Pickup'
	PickupForce="FlakCannonPickup"

	MaxDesireability=+0.75
	Standup=(Y=0.25)

	DrawType=DT_StaticMesh
	StaticMesh=StaticMesh'ripjackSM.RipjackPickupMesh'
	DrawScale=0.4
}

