//==================================================
// RipjackAltFire
//
// Author: Radiosity
//==================================================

class RipjackAltFire extends RipjackFire;

var() float	ChargeUpRate;
var() int	MaxCharge;
var() int	Charge;
var Ripjack	Gun;

function ModeHoldFire()
{
	if ( Weapon.AmmoAmount(ThisModeNum) > 0 )
	{
        	Super.ModeHoldFire();
        	GotoState('Hold');
	}
}

simulated function PlayStartHold()
{
	Weapon.PlayAnim('Charge', 1.0 / (ChargeUpRate*MaxCharge), 0.1);
}

simulated function PlayFiring()
{
	Super.PlayFiring();
	Weapon.OutOfAmmo();
}

state Hold
{
	simulated function BeginState()
	{
		Gun = Ripjack(Weapon);

		Gun.bIsCharging = True; // increase blade spin speed
		Gun.HeatEffect.ActivateEmitter(); //activate the heat effect after charging for a while
		Gun.HeatEffect.bActive = True;
	        Charge = 0;
        	SetTimer(ChargeUpRate, true);
		Instigator.AmbientSound = sound'ripjackSounds.Ripjack_Charge';
		Instigator.SoundRadius = 100;
		Instigator.SoundVolume = 200;
        	Weapon.ClientPlayForceFeedback( "BioRiflePowerUp" );  // jdf
	        Timer();
	}

	simulated function Timer()
	{
		Charge++;

        	if (Charge == MaxCharge)
	        {
        		SetTimer(0.0, false);
			Instigator.AmbientSound = sound'ripjackSounds.Ripjack_HoldLoop';
			Instigator.SoundRadius = 100;
			Instigator.SoundVolume = 200;
	        }
	}

	simulated function EndState()
	{
		if ( (Instigator != None) && (Instigator.AmbientSound == sound'ripjackSounds.Ripjack_HoldLoop') || (Instigator.AmbientSound == sound'ripjackSounds.Ripjack_Charge') )
			Instigator.AmbientSound = None;
		Instigator.SoundRadius = Instigator.Default.SoundRadius;
		Instigator.SoundVolume = Instigator.Default.SoundVolume;

	        StopForceFeedback( "BioRiflePowerUp" );

		Gun = Ripjack(Weapon);
		Gun.bIsCharging = False; // set blade spin back to normal
		Gun.HeatEffect.DeactivateEmitter(); // kill the heat emitter
	}
}

function projectile SpawnProjectile(Vector Start, Rotator Dir)
{
	local RipjackAltRazor Razor;

	GotoState('');

	if (Charge == 0) return None;

	Razor = Weapon.Spawn(class'RipjackAltRazor',,, Start, Dir);
	if ( Razor != None )
	{
		Razor.Damage *= DamageAtten;
		Razor.SetCharge(Charge);
		Razor.AdjustSpeed();
		Razor.ScaleEmitter(); // more charge = bigger trail effect
	}
	Charge = 0;

	return Razor;
}

defaultproperties
{
	ChargeUpRate=0.25
	MaxCharge=10

	FireAnim="Fire1"
	FireAnimRate=0.75

	bFireOnRelease=true
	bSplashDamage=true
	bRecommendSplashDamage=true

	ProjectileClass=class'Ripjack.RipjackAltRazor'

	FireSound=Sound'ripjackSounds.Ripjack_Fire'

	FireRate=1.0
	BotRefireRate=0.7
	WarnTargetPct=+0.5
}

