//=============================================================
// Author: Radiosity
// ============================================================

class DamTypeRipjackRazorHeadshot extends WeaponDamageType
	abstract;

var class<LocalMessage>		KillerMessage;
var sound			HeadHunter;

static function IncrementKills(Controller Killer)
{
	local xPlayerReplicationInfo xPRI;
	
	if ( PlayerController(Killer) == None )
		return;
		
	PlayerController(Killer).ReceiveLocalizedMessage( Default.KillerMessage, 0, Killer.PlayerReplicationInfo, None, None );
	xPRI = xPlayerReplicationInfo(Killer.PlayerReplicationInfo);
	if ( xPRI != None )
	{
		xPRI.headcount++;
		if ( (xPRI.headcount == 15) && (UnrealPlayer(Killer) != None) )
			UnrealPlayer(Killer).ClientDelayedAnnouncement(Default.HeadHunter,15);
	}
}		

defaultproperties
{
	KillerMessage=Class'XGame.SpecialKillMessage'
	HeadHunter=Sound'AnnouncerMain.HeadHunter'
	WeaponClass=Class'Ripjack.Ripjack'

	DeathString="%k took %o's head off with a Razor."
	FemaleSuicide="%o removed her own head."
	MaleSuicide="%o removed his own head."

	bAlwaysSevers=True
	bSpecial=True
	bCauseConvulsions=True
}
