//==================================================
// Ripjack
//
// Author: Radiosity
//==================================================

class Ripjack extends Weapon
	config(Ripjack);

var float	OldTime;
var rotator	BladeRot;
var bool	bIsCharging;

var RipjackHeatTrail	HeatEffect;

simulated function PostNetBeginPlay()
{
	if (Level.Netmode != NM_DedicatedServer)
	{
		SpawnHeatTrails();
	}

	Super.PostNetBeginPlay();
}

simulated function SpawnHeatTrails()
{
	if (Level.NetMode == NM_DedicatedServer)
		return;

       	HeatEffect = spawn(class'RipjackHeatTrail');

	AttachToBone(HeatEffect, 'bladeBone');
}

simulated function AnimEnd(int Channel)
{
	local name anim;
	local float frame, rate;
	GetAnimParams(0, anim, frame, rate);

	if (anim == 'Charge')
	        LoopAnim('Charge', 1.0, 0.1);
	else
	        Super.AnimEnd(Channel);
}

simulated function Tick(float dt)
{
	if(bIsCharging) // spin the blade faster while charging
	{
		BladeRot.Yaw -= 200000 * (Level.TimeSeconds - OldTime);
		OldTime = Level.TimeSeconds;
		SetBoneRotation('bladeBone',BladeRot,0);
	}

	else

	// spin the blade
	BladeRot.Yaw -= 80000 * (Level.TimeSeconds - OldTime);
	OldTime = Level.TimeSeconds;
	SetBoneRotation('bladeBone',BladeRot,0);

	Super.Tick(dt);
}

simulated function Destroyed()
{
	if (HeatEffect != None)
	HeatEffect.Destroy();

    Super.Destroyed();
}

simulated function PlayFiring(bool bExpand)
{
	// FIXME crappy hack until I think of a better way to handle this...
	if (bExpand)
	{
		GotoState('expand');
	}
}

simulated state expand
{
Begin:

	setBoneScale(0,0.3,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.4,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.5,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.6,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.7,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.8,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.9,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,1.0,'bladeBone');
	GotoState('');
}

simulated function float ChargeBar()
{
	local float CurrentCharge, MaxCharge;

	CurrentCharge = RipjackAltFire(FireMode[1]).Charge;
	MaxCharge = RipjackAltFire(FireMode[1]).MaxCharge;

	return FMin(1, CurrentCharge/MaxCharge);
}

function float GetAIRating()
{
	local Bot B;
	local float EnemyDist;
	local vector EnemyDir;

	B = Bot(Instigator.Controller);
	if ( B == None )
		return AIRating;

	if ( (B.Target != None) && (Pawn(B.Target) == None) && (VSize(B.Target.Location - Instigator.Location) < 1250) )
		return +0.3;

	if ( B.Enemy == None )
		return AIRating;

	EnemyDir = B.Enemy.Location - Instigator.Location;
	EnemyDist = VSize(EnemyDir);
	if ( EnemyDist > 1950 )
	{
		if ( EnemyDist > 3000 )
		{
			if ( EnemyDist > 3900 )
				return 0.6;
			return (AIRating - 0.4);
		}
		if ( EnemyDir.Z < -0.5 * EnemyDist )
			return (AIRating - 0.2);
	}
	else if ( (B.Enemy.Weapon != None) && B.Enemy.Weapon.bMeleeWeapon )
		return (AIRating + 0.35);
	else if ( EnemyDist < 1400 )
		return (AIRating + 0.4);

	return FMax(AIRating + 0.2 - (EnemyDist - 1400) * 0.0008, 0.2);
}

function byte BestMode()
{
	local vector EnemyDir;
	local float EnemyDist;
	local bot B;

	B = Bot(Instigator.Controller);
	if ( (B == None) || (B.Enemy == None) )
		return 0;

	EnemyDir = B.Enemy.Location - Instigator.Location;
	EnemyDist = VSize(EnemyDir);
	if ( EnemyDist > 900 )
	{
		if ( EnemyDir.Z < -0.5 * EnemyDist )
			return 1;
		return 0;
	}
	else if ( (B.Enemy.Weapon != None) && B.Enemy.Weapon.bMeleeWeapon )
		return 0;
	else if ( (B.Enemy.DrivenVehicle != None) && B.Enemy.DrivenVehicle.bDriving ) // FIXME doesn't appear to work
		return 1;
	else if ( (EnemyDist < 700) || (EnemyDir.Z > 30) )
		return 0;
	else if ( FRand() < 0.65 )
		return 1;
	return 0;
}

function float SuggestAttackStyle()
{
	if ( (AIController(Instigator.Controller) != None)
		&& (AIController(Instigator.Controller).Skill < 3) )
		return 0.4;
	return 0.8;
}

function float SuggestDefenseStyle()
{
	return -0.3;
}

defaultproperties
{
	FireModeClass(0)=Ripjack.RipjackFire
	FireModeClass(1)=Ripjack.RipjackAltFire
	PickupClass=class'Ripjack.RipjackPickup'
	AttachmentClass=class'Ripjack.RipjackAttachment'

	EffectOffset=(X=200.0,Y=32.0,Z=-25.0)
	PlayerViewOffset=(X=9.000000,Y=8,Z=-10.000000)
	PlayerViewPivot=(Pitch=0,Yaw=-100,Roll=-50)
	SmallViewOffset=(X=16,Y=8,Z=-13)
	CenteredOffsetY=1.5
	CenteredYaw=-200
	CenteredRoll=300

	DisplayFOV=50
	BobDamping=2.2

	bShowChargingBar=true

	AIRating=+0.75
	CurrentRating=+0.75

	InventoryGroup=6
	GroupOffset=3
	DefaultPriority=12
	Priority=12

	SelectAnim="Select"
	SelectAnimRate=0.85
	PutDownAnim="PutDown"
	PutDownAnimRate=0.9
	IdleAnim="Idle"
	IdleAnimRate=0.75

	SelectForce="SwitchToFlakCannon"
	SelectSound=Sound'ripjackSounds.Ripjack_Select'

	ItemName="Ripjack"
	IconMaterial=Material'ripjackTex.RipjackIconW'
	IconCoords=(X1=44,Y1=36,X2=132,Y2=76)
	HudColor=(r=188,g=185,b=174,a=255)

	CustomCrosshair=0
	CustomCrosshairTextureName="ripjackTex.RipjackCrosshair"
	CustomCrosshairColor=(r=188,g=185,b=174,a=255)

	Mesh=mesh'ripjackAnim.RipjackMesh_1st'
	DrawScale=0.375

	Description="Liandri's continued failure to deliver an updated replacement for the beloved Ripper has led an independant weapons developer to take up the gauntlet. The weapons and munitions division of R.A.D. Technologies has most certainly delivered the goods. Featuring a sleek new look combined with deadly destructive capabilites, the MkII Ripjack is a lethal weapon to be faced with. Get too cocky and you could easily lose your head. Twitch your trigger finger at just the wrong moment and you could just as easily shred yourself with an explosive razor. Utmost caution is advised both while wielding the weapon and facing a competent opponent wielding it."
}

