//==================================================
// RipjackRazor
//
// Author: Radiosity
//==================================================

class RipjackRazor extends Projectile;

var Emitter		Trail1;
var() class<DamageType>	DamageTypeHeadShot;
var() float		HeadShotRadius, HeadshotDamage, DamageAtten;
var bool		bBounced; // set after the first bounce - needed for self damaging


simulated function PostBeginPlay()
{
	if (Level.Netmode != NM_DedicatedServer)
	{
		Trail1 = Spawn(class'RipjackTrail',,, Location);
		Trail1.SetBase(self);
	}

	Velocity=Speed*Vector(Rotation);

	if (PhysicsVolume.bWaterVolume)
        Velocity *= 0.65;

	Super.PostBeginPlay();
}

simulated function Destroyed()
{
	if(Trail1 != None)
	Trail1.Kill();

	Super.Destroyed();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	local vector	x;
	local float	dist;

	if ( (RipjackRazor(Other) == None) && ((bBounced) || (Other != Instigator)) )
	{
        	speed = VSize(Velocity);
	        if ( speed > 200 )
        	{
		        if ( Role == ROLE_Authority )
				if (!Other.bWorldGeometry)
				{
					// handle headshots here
					if ((Pawn(Other) != None) && Other.GetClosestBone( HitLocation, x, dist, 'head', HeadShotRadius) == 'head' )
                        			Other.TakeDamage(HeadshotDamage, Instigator, HitLocation, x, DamageTypeHeadShot);
						else
                				Other.TakeDamage(Max(5, Damage - DamageAtten*FMax(0,(default.LifeSpan - LifeSpan - 1))), Instigator, HitLocation, (MomentumTransfer * Velocity/speed), MyDamageType);
				}
        	}
	Destroy();
	}
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
	{
        	if ( Level.NetMode != NM_Client )
		Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), MyDamageType);

        	Destroy();

        	return;
	}

	bBounced = True;

	Velocity = 0.95 * (Velocity - 2.0*HitNormal*(Velocity dot HitNormal)); // slow the projectile after bounce

	SetRotation(rotator(Velocity));

	PlaySound(sound'ripjackSounds.Ripjack_Chink',SLOT_None,0.6,,300,0.9+frand()*0.2);
        if ( EffectIsRelevant(Location,false) )
            Spawn(class'RipjackImpact',,,, rotator(hitnormal));
}

simulated function PhysicsVolumeChange( PhysicsVolume Volume )
{
	if (Volume.bWaterVolume)
	{
        	if ( Trail1 != None )
		Trail1.Destroy();

        	Velocity *= 0.85;
	}
}

defaultproperties
{
	HeadshotRadius=45.0
	HeadshotDamage=500.0
	DamageAtten=2.0
	Speed=2000.0
	MaxSpeed=2000.0
	Damage=38.0
	MomentumTransfer=7500.0

	CullDistance=+8000.0
	NetPriority=2.50

	MyDamageType=Class'Ripjack.DamTypeRipjackRazor'
	DamageTypeHeadShot=Class'Ripjack.DamTypeRipjackRazorHeadshot'

	DrawType=DT_Mesh
	Mesh=Mesh'ripjackAnim.RipbladeMesh'
	LifeSpan=4.0
	DrawScale=0.6
	AmbientGlow=254
	Style=STY_Alpha

	AmbientSound=Sound'ripjackSounds.Ripjack_RazorHum'

	FluidSurfaceShootStrengthMod=1.f

	SoundRadius=120.0
	SoundVolume=70.0

	CollisionHeight=7.0
	CollisionRadius=20.0

	bBounce=True
}

