//==================================================
// RipjackRazor
//
// Author: Radiosity
//==================================================

class RipjackAltRazor extends Projectile;

//var Emitter		Trail1;

var() int		BaseDamage;
var int			Charge;
var float		ChargeAmount;
var RipjackAltTrail	Trail1;
var class<DamageType>	AltDamageType;

simulated function PostBeginPlay()
{

	if (Level.Netmode != NM_DedicatedServer)
	{
		Trail1 = Spawn(class'RipjackAltTrail',,, Location);
		Trail1.SetBase(self);
	}

	Velocity=Speed*Vector(Rotation);

	if (PhysicsVolume.bWaterVolume)
        Velocity *= 0.65;

	Super.PostBeginPlay();
}

function AdjustSpeed()
{
	if ( Charge < 4 )
		Velocity = Vector(Rotation) * Speed * (1.4 + Charge)/(1.4*Charge);
	else
		Velocity = Vector(Rotation) * Speed * (1.4 + Charge)/(0.8*Charge); // ramp up speed a little with more charge
}

function ScaleEmitter()
{
	// scales the trail emitter depending on charge
	if ( Charge >= 3 )
	{
		Trail1.ChargeAmount = 1;
	}
	else if ( Charge >= 6 )
	{
		Trail1.ChargeAmount = 2;
	}
	else if ( Charge == 10 )
	{
		Trail1.ChargeAmount = 3;
	}
	else
		Trail1.ChargeAmount = 0;

	Trail1.SetupEffect();
}	

simulated function Destroyed()
{
	if(Trail1 != None)
	Trail1.Kill();

	Super.Destroyed();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	if ( Other != Instigator )
	{
		SpawnEffects(HitLocation, -1 * Normal(Velocity) );
		Explode(HitLocation,Normal(HitLocation-Other.Location));
	}
}

simulated function SpawnEffects( vector HitLocation, vector HitNormal )
{
	local PlayerController PC;

	PlaySound (Sound'ripjackSounds.Ripjack_Explode',,3*TransientSoundVolume);
	if ( EffectIsRelevant(Location,false) )
	{
		PC = Level.GetLocalPlayerController();
		if ( (PC.ViewTarget != None) && VSize(PC.ViewTarget.Location - Location) < 9000 )
		Spawn(class'RipjackExplode',,, HitLocation + HitNormal*5, rotator(-HitNormal));
		if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
			Spawn(ExplosionDecal,self,,HitLocation, rotator(-HitNormal));
	}
}

simulated function Landed( Vector HitNormal )
{
	SpawnEffects( Location, HitNormal );
	Explode(Location,HitNormal);
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	Landed(HitNormal);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	local vector start;
	local rotator rot;
	local int i;
	local RipjackShard NewChunk;

	start = Location + 10 * HitNormal;
	if ( Role == ROLE_Authority )
	{
		// handle damage scaling depending on charge here
	        Damage = BaseDamage + Damage * Charge;
	        DamageRadius = DamageRadius * ChargeAmount;
	        MomentumTransfer = MomentumTransfer * ChargeAmount;
		if( FRand() > 0.5)
		{
			// AltDamageType has bAlwaysGib set true for instant gibbage
	        	DelayedHurtRadius(Damage, DamageRadius, AltDamageType, MomentumTransfer, HitLocation);
		}
		else
			// standard damagetype
	        	DelayedHurtRadius(Damage, DamageRadius, MyDamageType, MomentumTransfer, HitLocation);
	
		for (i=0; i<6; i++)
		{
			// borrowed from FlakShell.uc to add some sneaky extra damage to the projectile ;)
			rot = Rotation;
			rot.yaw += FRand()*32000-16000;
			rot.pitch += FRand()*32000-16000;
			rot.roll += FRand()*32000-16000;
			NewChunk = Spawn( class 'RipjackShard',, '', Start, rot);
		}
	}
	Destroy();
}

simulated function SetCharge( int NewCharge )
{
	Charge = NewCharge;
	ChargeAmount = sqrt(float(Charge));
	LightBrightness = Min(100 + 15*Charge, 255);
	LightRadius = 2.7 + 0.2*Charge;
	FluidSurfaceShootStrengthMod=5.f + 0.3 * NewCharge;
}

simulated function PhysicsVolumeChange( PhysicsVolume Volume )
{
	if (Volume.bWaterVolume)
	{
        	if ( Trail1 != None )
		Trail1.Destroy();

        	Velocity *= 0.85;
	}
}

defaultproperties
{
	Charge=1
	ChargeAmount=1.25

	Speed=1050.000000
	MaxSpeed=1050.000000
	BaseDamage=15.0
	Damage=15.000000
	DamageRadius=100.0
	MomentumTransfer=35000.000000

	CullDistance=+9000.0
	bNetTemporary=True
	NetPriority=2.500000

	ExplosionDecal=class'ShockAltDecal'
	MyDamageType=Class'Ripjack.DamTypeRipjackAltRazor'
	AltDamageType=Class'Ripjack.DamTypeRipjackAltRazorGib'

	DrawType=DT_Mesh
	Mesh=Mesh'ripjackAnim.RipbladeMesh'
	LifeSpan=7.000000
	DrawScale=0.600000
	AmbientGlow=254
	Style=STY_Alpha

	AmbientSound=Sound'ripjackSounds.Ripjack_RazorHum'

	FluidSurfaceShootStrengthMod=3.f

	SoundRadius=150.000000
	SoundVolume=100.000000

	CollisionHeight=7.000000
	CollisionRadius=25.000000

	bUnlit=True

	bDynamicLight=true
	LightType=LT_Steady
	LightEffect=LE_QuadraticNonIncidence
	LightBrightness=190
	LightHue=35
	LightSaturation=10
	LightRadius=0.8
}

