//==================================================
// RipjackFire
//
// Author: Radiosity
//==================================================

class RipjackFire extends ProjectileFire;

simulated function PlayFiring()
{
	Super.PlayFiring();

	RipJack(Weapon).PlayFiring(true);
}

defaultproperties
{
	AmmoClass=class'Ripjack.RipjackAmmo'
	AmmoPerFire=1

	FireAnim="Fire1"
	FireAnimRate=0.75
	FireEndAnim=None

	ProjectileClass=class'Ripjack.RipjackRazor'
	ProjSpawnOffset=(X=10,Y=10,Z=-8)

	FireSound=Sound'ripjackSounds.Ripjack_Fire'
	FireForce="FlakCannonFire"

	FireRate=0.8
	BotRefireRate=0.7
	bModeExclusive=True

	ShakeOffsetMag=(X=-20.0,Y=0.00,Z=0.00)
	ShakeOffsetRate=(X=-1000.0,Y=0.0,Z=0.0)
	ShakeOffsetTime=2
	ShakeRotMag=(X=0.0,Y=0.0,Z=0.0)
	ShakeRotRate=(X=0.0,Y=0.0,Z=0.0)
	ShakeRotTime=2
}

