class RipjackExplode extends Emitter;

simulated function PostNetBeginPlay()
{
	local PlayerController PC;
	local float dist;

	PC = Level.GetLocalPlayerController();
	if ( Level.NetMode == NM_DedicatedServer || PC == None )
		return;

	if ( PC.ViewTarget == None )
		dist = 10000;
	else
		dist = VSize(PC.ViewTarget.Location - Location);
	if ( dist > 4000 )
	{
		LightType = LT_None;
		bDynamicLight = false;
		if ( dist > 7000 )
			Emitters[2].Disabled = true;
	}
}

defaultproperties
{
    Begin Object Class=SpriteEmitter Name=SpriteEmitter5
        RespawnDeadParticles=False
        SpinParticles=True
        UniformSize=True
        AutomaticInitialSpawning=False
        BlendBetweenSubdivisions=True
        MaxParticles=3
        StartLocationShape=PTLS_Sphere
        SphereRadiusRange=(Min=24.000000,Max=24.000000)
        StartSpinRange=(X=(Max=1.000000))
        StartSizeRange=(X=(Min=50.000000,Max=70.000000),Y=(Min=50.000000,Max=70.000000),Z=(Min=50.000000,Max=70.000000))
        InitialParticlesPerSecond=10.000000
        Texture=Texture'ripjackTex.Ripjack_explode'
        TextureUSubdivisions=3
        TextureVSubdivisions=3
        SecondsBeforeInactive=0.000000
        LifetimeRange=(Min=0.400000,Max=0.600000)
    End Object
    Emitters(0)=SpriteEmitter'SpriteEmitter5'

    Begin Object Class=SpriteEmitter Name=SpriteEmitter6
        UseColorScale=True
        RespawnDeadParticles=False
        SpinParticles=True
        UseSizeScale=True
        UseRegularSizeScale=False
        UniformSize=True
        AutomaticInitialSpawning=False
        UseRandomSubdivision=True
        UseVelocityScale=True
        Acceleration=(Z=20.000000)
        ColorScale(0)=(Color=(B=255,G=255,R=255))
        ColorScale(1)=(RelativeTime=0.125000,Color=(B=255,G=255,R=255))
        ColorScale(2)=(RelativeTime=0.330000,Color=(B=255,G=255,R=255,A=255))
        ColorScale(3)=(RelativeTime=0.750000,Color=(B=128,G=128,R=128,A=255))
        ColorScale(4)=(RelativeTime=1.000000,Color=(B=64,G=64,R=64))
        MaxParticles=20
        StartLocationShape=PTLS_Polar
        StartLocationPolarRange=(Y=(Min=-32768.000000,Max=32768.000000),Z=(Min=10.000000,Max=10.000000))
        UseRotationFrom=PTRS_Actor
        RotationOffset=(Yaw=-16384)
        SpinsPerSecondRange=(X=(Max=0.100000))
        StartSpinRange=(X=(Max=1.000000))
        SizeScale(0)=(RelativeSize=0.200000)
        SizeScale(1)=(RelativeTime=1.000000,RelativeSize=0.500000)
        StartSizeRange=(X=(Min=75.000000,Max=75.000000))
        InitialParticlesPerSecond=500.000000
        DrawStyle=PTDS_AlphaBlend
        Texture=Texture'AW-2004Particles.Fire.MuchSmoke2t'
        TextureUSubdivisions=4
        TextureVSubdivisions=4
        LifetimeRange=(Min=2.000000,Max=2.000000)
        InitialDelayRange=(Min=0.100000,Max=0.100000)
        StartVelocityRadialRange=(Min=200.000000,Max=250.000000)
        GetVelocityDirectionFrom=PTVD_AddRadial
        VelocityScale(0)=(RelativeVelocity=(X=1.000000,Y=1.000000,Z=1.000000))
        VelocityScale(1)=(RelativeTime=0.300000,RelativeVelocity=(X=0.100000,Y=0.100000,Z=0.100000))
        VelocityScale(2)=(RelativeTime=1.000000)
    End Object
    Emitters(1)=SpriteEmitter'SpriteEmitter6'

    Begin Object Class=SpriteEmitter Name=SpriteEmitter7
        UseDirectionAs=PTDU_Up
        UseCollision=True
        UseColorScale=True
        FadeOut=True
        RespawnDeadParticles=False
        UseSizeScale=True
        UseRegularSizeScale=False
        AutomaticInitialSpawning=False
        Acceleration=(Z=-600.000000)
        ExtentMultiplier=(X=0.200000,Y=0.200000,Z=0.200000)
        DampingFactorRange=(X=(Min=0.400000,Max=0.400000),Y=(Min=0.400000,Max=0.400000),Z=(Min=0.800000,Max=0.800000))
        ColorScale(0)=(Color=(B=162,G=180,R=187))
        ColorScale(1)=(RelativeTime=1.000000)
        FadeOutStartTime=0.200000
        MaxParticles=30
        DetailMode=DM_High
        StartLocationShape=PTLS_Sphere
        SphereRadiusRange=(Min=-6.000000,Max=6.000000)
        SizeScale(0)=(RelativeSize=1.100000)
        SizeScale(1)=(RelativeTime=0.500000,RelativeSize=0.100000)
        SizeScale(2)=(RelativeTime=1.000000)
        StartSizeRange=(X=(Min=6.000000,Max=7.000000),Y=(Min=20.000000,Max=30.000000))
        InitialParticlesPerSecond=500.000000
        Texture=Texture'AW-2004Particles.Energy.SparkHead'
        LifetimeRange=(Min=2.000000,Max=2.250000)
        StartVelocityRange=(X=(Min=-400.000000,Max=400.000000),Y=(Min=-400.000000,Max=400.000000),Z=(Max=400.000000))
        StartVelocityRadialRange=(Min=-100.000000,Max=100.000000)
        GetVelocityDirectionFrom=PTVD_AddRadial
    End Object
    Emitters(2)=SpriteEmitter'SpriteEmitter7'

    Begin Object Class=SpriteEmitter Name=SpriteEmitter8
        FadeOut=True
        RespawnDeadParticles=False
        UniformSize=True
        AutomaticInitialSpawning=False
        FadeOutStartTime=0.025000
        MaxParticles=1
        StartSizeRange=(X=(Min=150.000000,Max=150.000000))
        InitialParticlesPerSecond=1000.000000
        Texture=Texture'EpicParticles.Flares.SoftFlare'
        LifetimeRange=(Min=0.350000,Max=0.350000)
    End Object
    Emitters(3)=SpriteEmitter'SpriteEmitter8'

    Begin Object Class=SpriteEmitter Name=SpriteEmitter9
        UseDirectionAs=PTDU_Normal
        ProjectionNormal=(X=1.000000,Z=0.000000)
        FadeOut=True
        RespawnDeadParticles=False
        SpinParticles=True
        UniformSize=True
        AutomaticInitialSpawning=False
        Opacity=0.800000
        FadeOutStartTime=0.500000
        MaxParticles=1
        StartLocationOffset=(X=-2.000000)
        UseRotationFrom=PTRS_Actor
        StartSpinRange=(X=(Max=1.000000))
        StartSizeRange=(X=(Min=175.000000,Max=175.000000))
        InitialParticlesPerSecond=500.000000
        Texture=Texture'EpicParticles.Flares.SoftFlare'
        LifetimeRange=(Min=2.500000,Max=2.500000)
    End Object
    Emitters(4)=SpriteEmitter'SpriteEmitter9'
    
	bNoDelete=false
	AutoDestroy=true
	RemoteRole=ROLE_None
}