//==================================================
// RipjackAttachment
//
// Author: Radiosity
//==================================================

class RipjackAttachment extends xWeaponAttachment;

var() float	NewBladeScale;
var float	OldTime;
var rotator	BladeRot;

simulated event Tick(float dt)
{
	// same as weapon class, but don't bother increasing speed while charging, no point for 3rd person really
	BladeRot.Yaw -= 100000 * (Level.TimeSeconds - OldTime);
	OldTime = Level.TimeSeconds;
	SetBoneRotation('bladeBone',BladeRot,0);

	Super.Tick(dt);
}

simulated event ThirdPersonEffects()
{
	if ( Level.NetMode != NM_DedicatedServer && FlashCount > 0 )
	{
		PlayAnim('Fire',0.75);
		setBoneScale(0,NewBladeScale,'bladeBone');
		// FIXME
		GotoState('Expand');
	}

	Super.ThirdPersonEffects();
}

simulated state Expand
{
Begin:

	setBoneScale(0,0.3,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.4,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.5,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.6,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.7,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.8,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,0.9,'bladeBone');
	Sleep(0.1);
	setBoneScale(0,1.0,'bladeBone');
	GotoState('');
}

defaultproperties
{
	NewBladeScale=0.0
	bHeavy=False
	bRapidFire=False
	bAltRapidFire=False

	Mesh=Mesh'ripjackAnim.RipjackMesh_3rd'
	DrawScale=0.3
	RelativeLocation=(X=-2.0)
}

